/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GeminiChatCompletionFactoryImpl extends EFactoryImpl implements GeminiChatCompletionFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GeminiChatCompletionFactory init() {
		try {
			GeminiChatCompletionFactory theGeminiChatCompletionFactory = (GeminiChatCompletionFactory)EPackage.Registry.INSTANCE.getEFactory(GeminiChatCompletionPackage.eNS_URI);
			if (theGeminiChatCompletionFactory != null) {
				return theGeminiChatCompletionFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new GeminiChatCompletionFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeminiChatCompletionFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST: return createGeminiChatCompletionRequest();
			case GeminiChatCompletionPackage.CONTENT: return createContent();
			case GeminiChatCompletionPackage.PART: return createPart();
			case GeminiChatCompletionPackage.GENERATION_CONFIG: return createGenerationConfig();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE: return createGeminiChatCompletionResponse();
			case GeminiChatCompletionPackage.USAGE_METADATA: return createUsageMetadata();
			case GeminiChatCompletionPackage.PROMPT_TOKENS_DETAIL: return createPromptTokensDetail();
			case GeminiChatCompletionPackage.CANDIDATE: return createCandidate();
			case GeminiChatCompletionPackage.SYSTEM_INSTRUCTION: return createSystemInstruction();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeminiChatCompletionRequest createGeminiChatCompletionRequest() {
		GeminiChatCompletionRequestImpl geminiChatCompletionRequest = new GeminiChatCompletionRequestImpl();
		return geminiChatCompletionRequest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Content createContent() {
		ContentImpl content = new ContentImpl();
		return content;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Part createPart() {
		PartImpl part = new PartImpl();
		return part;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GenerationConfig createGenerationConfig() {
		GenerationConfigImpl generationConfig = new GenerationConfigImpl();
		return generationConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeminiChatCompletionResponse createGeminiChatCompletionResponse() {
		GeminiChatCompletionResponseImpl geminiChatCompletionResponse = new GeminiChatCompletionResponseImpl();
		return geminiChatCompletionResponse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public UsageMetadata createUsageMetadata() {
		UsageMetadataImpl usageMetadata = new UsageMetadataImpl();
		return usageMetadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PromptTokensDetail createPromptTokensDetail() {
		PromptTokensDetailImpl promptTokensDetail = new PromptTokensDetailImpl();
		return promptTokensDetail;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Candidate createCandidate() {
		CandidateImpl candidate = new CandidateImpl();
		return candidate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemInstruction createSystemInstruction() {
		SystemInstructionImpl systemInstruction = new SystemInstructionImpl();
		return systemInstruction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeminiChatCompletionPackage getGeminiChatCompletionPackage() {
		return (GeminiChatCompletionPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static GeminiChatCompletionPackage getPackage() {
		return GeminiChatCompletionPackage.eINSTANCE;
	}

} //GeminiChatCompletionFactoryImpl
