/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionFactory;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Part;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GeminiChatCompletionPackageImpl extends EPackageImpl implements GeminiChatCompletionPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geminiChatCompletionRequestEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass partEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass generationConfigEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geminiChatCompletionResponseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass usageMetadataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass promptTokensDetailEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass candidateEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass systemInstructionEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private GeminiChatCompletionPackageImpl() {
		super(eNS_URI, GeminiChatCompletionFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link GeminiChatCompletionPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static GeminiChatCompletionPackage init() {
		if (isInited) return (GeminiChatCompletionPackage)EPackage.Registry.INSTANCE.getEPackage(GeminiChatCompletionPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredGeminiChatCompletionPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		GeminiChatCompletionPackageImpl theGeminiChatCompletionPackage = registeredGeminiChatCompletionPackage instanceof GeminiChatCompletionPackageImpl ? (GeminiChatCompletionPackageImpl)registeredGeminiChatCompletionPackage : new GeminiChatCompletionPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		JsonSchemaPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theGeminiChatCompletionPackage.createPackageContents();

		// Initialize created meta-data
		theGeminiChatCompletionPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theGeminiChatCompletionPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(GeminiChatCompletionPackage.eNS_URI, theGeminiChatCompletionPackage);
		return theGeminiChatCompletionPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeminiChatCompletionRequest() {
		return geminiChatCompletionRequestEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeminiChatCompletionRequest_Contents() {
		return (EReference)geminiChatCompletionRequestEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeminiChatCompletionRequest_SystemInstruction() {
		return (EReference)geminiChatCompletionRequestEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeminiChatCompletionRequest_GenerationConfig() {
		return (EReference)geminiChatCompletionRequestEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContent() {
		return contentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContent_Role() {
		return (EAttribute)contentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContent_Parts() {
		return (EReference)contentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPart() {
		return partEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPart_Text() {
		return (EAttribute)partEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGenerationConfig() {
		return generationConfigEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGenerationConfig_ResponseMimeType() {
		return (EAttribute)generationConfigEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGenerationConfig_ResponseJsonSchema() {
		return (EReference)generationConfigEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeminiChatCompletionResponse() {
		return geminiChatCompletionResponseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGeminiChatCompletionResponse_ResponseId() {
		return (EAttribute)geminiChatCompletionResponseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGeminiChatCompletionResponse_ModelVersion() {
		return (EAttribute)geminiChatCompletionResponseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeminiChatCompletionResponse_Candidates() {
		return (EReference)geminiChatCompletionResponseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeminiChatCompletionResponse_UsageMetadata() {
		return (EReference)geminiChatCompletionResponseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getUsageMetadata() {
		return usageMetadataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsageMetadata_PromptTokenCount() {
		return (EAttribute)usageMetadataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsageMetadata_CandidatesTokenCount() {
		return (EAttribute)usageMetadataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsageMetadata_TotalTokenCount() {
		return (EAttribute)usageMetadataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsageMetadata_ThoughtsTokenCount() {
		return (EAttribute)usageMetadataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getUsageMetadata_PromptTokensDetails() {
		return (EReference)usageMetadataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPromptTokensDetail() {
		return promptTokensDetailEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPromptTokensDetail_Modality() {
		return (EAttribute)promptTokensDetailEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPromptTokensDetail_TokenCount() {
		return (EAttribute)promptTokensDetailEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCandidate() {
		return candidateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCandidate_FinishReason() {
		return (EAttribute)candidateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCandidate_Index() {
		return (EAttribute)candidateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCandidate_Content() {
		return (EReference)candidateEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSystemInstruction() {
		return systemInstructionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getSystemInstruction_Parts() {
		return (EReference)systemInstructionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeminiChatCompletionFactory getGeminiChatCompletionFactory() {
		return (GeminiChatCompletionFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		geminiChatCompletionRequestEClass = createEClass(GEMINI_CHAT_COMPLETION_REQUEST);
		createEReference(geminiChatCompletionRequestEClass, GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS);
		createEReference(geminiChatCompletionRequestEClass, GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION);
		createEReference(geminiChatCompletionRequestEClass, GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG);

		contentEClass = createEClass(CONTENT);
		createEAttribute(contentEClass, CONTENT__ROLE);
		createEReference(contentEClass, CONTENT__PARTS);

		partEClass = createEClass(PART);
		createEAttribute(partEClass, PART__TEXT);

		generationConfigEClass = createEClass(GENERATION_CONFIG);
		createEAttribute(generationConfigEClass, GENERATION_CONFIG__RESPONSE_MIME_TYPE);
		createEReference(generationConfigEClass, GENERATION_CONFIG__RESPONSE_JSON_SCHEMA);

		geminiChatCompletionResponseEClass = createEClass(GEMINI_CHAT_COMPLETION_RESPONSE);
		createEAttribute(geminiChatCompletionResponseEClass, GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID);
		createEAttribute(geminiChatCompletionResponseEClass, GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION);
		createEReference(geminiChatCompletionResponseEClass, GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES);
		createEReference(geminiChatCompletionResponseEClass, GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA);

		usageMetadataEClass = createEClass(USAGE_METADATA);
		createEAttribute(usageMetadataEClass, USAGE_METADATA__PROMPT_TOKEN_COUNT);
		createEAttribute(usageMetadataEClass, USAGE_METADATA__CANDIDATES_TOKEN_COUNT);
		createEAttribute(usageMetadataEClass, USAGE_METADATA__TOTAL_TOKEN_COUNT);
		createEAttribute(usageMetadataEClass, USAGE_METADATA__THOUGHTS_TOKEN_COUNT);
		createEReference(usageMetadataEClass, USAGE_METADATA__PROMPT_TOKENS_DETAILS);

		promptTokensDetailEClass = createEClass(PROMPT_TOKENS_DETAIL);
		createEAttribute(promptTokensDetailEClass, PROMPT_TOKENS_DETAIL__MODALITY);
		createEAttribute(promptTokensDetailEClass, PROMPT_TOKENS_DETAIL__TOKEN_COUNT);

		candidateEClass = createEClass(CANDIDATE);
		createEAttribute(candidateEClass, CANDIDATE__FINISH_REASON);
		createEAttribute(candidateEClass, CANDIDATE__INDEX);
		createEReference(candidateEClass, CANDIDATE__CONTENT);

		systemInstructionEClass = createEClass(SYSTEM_INSTRUCTION);
		createEReference(systemInstructionEClass, SYSTEM_INSTRUCTION__PARTS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		JsonSchemaPackage theJsonSchemaPackage = (JsonSchemaPackage)EPackage.Registry.INSTANCE.getEPackage(JsonSchemaPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(geminiChatCompletionRequestEClass, GeminiChatCompletionRequest.class, "GeminiChatCompletionRequest", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGeminiChatCompletionRequest_Contents(), this.getContent(), null, "contents", null, 0, -1, GeminiChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGeminiChatCompletionRequest_SystemInstruction(), this.getSystemInstruction(), null, "systemInstruction", null, 0, 1, GeminiChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGeminiChatCompletionRequest_GenerationConfig(), this.getGenerationConfig(), null, "generationConfig", null, 0, 1, GeminiChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contentEClass, Content.class, "Content", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContent_Role(), ecorePackage.getEString(), "role", null, 0, 1, Content.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContent_Parts(), this.getPart(), null, "parts", null, 0, -1, Content.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(partEClass, Part.class, "Part", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPart_Text(), ecorePackage.getEString(), "text", null, 0, 1, Part.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(generationConfigEClass, GenerationConfig.class, "GenerationConfig", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGenerationConfig_ResponseMimeType(), ecorePackage.getEString(), "responseMimeType", null, 0, 1, GenerationConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGenerationConfig_ResponseJsonSchema(), theJsonSchemaPackage.getJsonSchema(), null, "responseJsonSchema", null, 0, 1, GenerationConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(geminiChatCompletionResponseEClass, GeminiChatCompletionResponse.class, "GeminiChatCompletionResponse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGeminiChatCompletionResponse_ResponseId(), ecorePackage.getEString(), "responseId", null, 0, 1, GeminiChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGeminiChatCompletionResponse_ModelVersion(), ecorePackage.getEString(), "modelVersion", null, 0, 1, GeminiChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGeminiChatCompletionResponse_Candidates(), this.getCandidate(), null, "candidates", null, 0, -1, GeminiChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGeminiChatCompletionResponse_UsageMetadata(), this.getUsageMetadata(), null, "usageMetadata", null, 0, 1, GeminiChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(usageMetadataEClass, UsageMetadata.class, "UsageMetadata", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUsageMetadata_PromptTokenCount(), ecorePackage.getEInt(), "promptTokenCount", null, 0, 1, UsageMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsageMetadata_CandidatesTokenCount(), ecorePackage.getEInt(), "candidatesTokenCount", null, 0, 1, UsageMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsageMetadata_TotalTokenCount(), ecorePackage.getEInt(), "totalTokenCount", null, 0, 1, UsageMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsageMetadata_ThoughtsTokenCount(), ecorePackage.getEInt(), "thoughtsTokenCount", null, 0, 1, UsageMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getUsageMetadata_PromptTokensDetails(), this.getPromptTokensDetail(), null, "promptTokensDetails", null, 0, -1, UsageMetadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(promptTokensDetailEClass, PromptTokensDetail.class, "PromptTokensDetail", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPromptTokensDetail_Modality(), ecorePackage.getEString(), "modality", null, 0, 1, PromptTokensDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPromptTokensDetail_TokenCount(), ecorePackage.getEInt(), "tokenCount", null, 0, 1, PromptTokensDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(candidateEClass, Candidate.class, "Candidate", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCandidate_FinishReason(), ecorePackage.getEString(), "finishReason", null, 0, 1, Candidate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCandidate_Index(), ecorePackage.getEInt(), "index", null, 0, 1, Candidate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCandidate_Content(), this.getContent(), null, "content", null, 0, 1, Candidate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(systemInstructionEClass, SystemInstruction.class, "SystemInstruction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSystemInstruction_Parts(), this.getPart(), null, "parts", null, 0, -1, SystemInstruction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// JsonProperty
		createJsonPropertyAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "complianceLevel", "17.0",
			   "oSGiCompatible", "true",
			   "basePackage", "org.eclipse.fennec.ai.chat.completion.model",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n \nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n \nSPDX-License-Identifier: EPL-2.0\n \nContributors:\n      Data In Motion - initial API and implementation"
		   });
	}

	/**
	 * Initializes the annotations for <b>JsonProperty</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createJsonPropertyAnnotations() {
		String source = "JsonProperty";
		addAnnotation
		  (getGeminiChatCompletionRequest_SystemInstruction(),
		   source,
		   new String[] {
			   "value", "system_instruction"
		   });
		addAnnotation
		  (getGenerationConfig_ResponseMimeType(),
		   source,
		   new String[] {
			   "value", "response_mime_type"
		   });
		addAnnotation
		  (getGenerationConfig_ResponseJsonSchema(),
		   source,
		   new String[] {
			   "value", "response_json_schema"
		   });
	}

} //GeminiChatCompletionPackageImpl
