/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Content;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionRequest;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.SystemInstruction;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Request</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl#getContents <em>Contents</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl#getSystemInstruction <em>System Instruction</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionRequestImpl#getGenerationConfig <em>Generation Config</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GeminiChatCompletionRequestImpl extends MinimalEObjectImpl.Container implements GeminiChatCompletionRequest {
	/**
	 * The cached value of the '{@link #getContents() <em>Contents</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContents()
	 * @generated
	 * @ordered
	 */
	protected EList<Content> contents;

	/**
	 * The cached value of the '{@link #getSystemInstruction() <em>System Instruction</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSystemInstruction()
	 * @generated
	 * @ordered
	 */
	protected SystemInstruction systemInstruction;

	/**
	 * The cached value of the '{@link #getGenerationConfig() <em>Generation Config</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGenerationConfig()
	 * @generated
	 * @ordered
	 */
	protected GenerationConfig generationConfig;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeminiChatCompletionRequestImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GeminiChatCompletionPackage.Literals.GEMINI_CHAT_COMPLETION_REQUEST;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Content> getContents() {
		if (contents == null) {
			contents = new EObjectContainmentEList<Content>(Content.class, this, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS);
		}
		return contents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemInstruction getSystemInstruction() {
		return systemInstruction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSystemInstruction(SystemInstruction newSystemInstruction, NotificationChain msgs) {
		SystemInstruction oldSystemInstruction = systemInstruction;
		systemInstruction = newSystemInstruction;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION, oldSystemInstruction, newSystemInstruction);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSystemInstruction(SystemInstruction newSystemInstruction) {
		if (newSystemInstruction != systemInstruction) {
			NotificationChain msgs = null;
			if (systemInstruction != null)
				msgs = ((InternalEObject)systemInstruction).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION, null, msgs);
			if (newSystemInstruction != null)
				msgs = ((InternalEObject)newSystemInstruction).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION, null, msgs);
			msgs = basicSetSystemInstruction(newSystemInstruction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION, newSystemInstruction, newSystemInstruction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GenerationConfig getGenerationConfig() {
		return generationConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGenerationConfig(GenerationConfig newGenerationConfig, NotificationChain msgs) {
		GenerationConfig oldGenerationConfig = generationConfig;
		generationConfig = newGenerationConfig;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG, oldGenerationConfig, newGenerationConfig);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGenerationConfig(GenerationConfig newGenerationConfig) {
		if (newGenerationConfig != generationConfig) {
			NotificationChain msgs = null;
			if (generationConfig != null)
				msgs = ((InternalEObject)generationConfig).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG, null, msgs);
			if (newGenerationConfig != null)
				msgs = ((InternalEObject)newGenerationConfig).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG, null, msgs);
			msgs = basicSetGenerationConfig(newGenerationConfig, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG, newGenerationConfig, newGenerationConfig));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS:
				return ((InternalEList<?>)getContents()).basicRemove(otherEnd, msgs);
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION:
				return basicSetSystemInstruction(null, msgs);
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG:
				return basicSetGenerationConfig(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS:
				return getContents();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION:
				return getSystemInstruction();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG:
				return getGenerationConfig();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS:
				getContents().clear();
				getContents().addAll((Collection<? extends Content>)newValue);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION:
				setSystemInstruction((SystemInstruction)newValue);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG:
				setGenerationConfig((GenerationConfig)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS:
				getContents().clear();
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION:
				setSystemInstruction((SystemInstruction)null);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG:
				setGenerationConfig((GenerationConfig)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__CONTENTS:
				return contents != null && !contents.isEmpty();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__SYSTEM_INSTRUCTION:
				return systemInstruction != null;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_REQUEST__GENERATION_CONFIG:
				return generationConfig != null;
		}
		return super.eIsSet(featureID);
	}

} //GeminiChatCompletionRequestImpl
