/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.Candidate;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionResponse;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Response</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl#getResponseId <em>Response Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl#getModelVersion <em>Model Version</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl#getCandidates <em>Candidates</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GeminiChatCompletionResponseImpl#getUsageMetadata <em>Usage Metadata</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GeminiChatCompletionResponseImpl extends MinimalEObjectImpl.Container implements GeminiChatCompletionResponse {
	/**
	 * The default value of the '{@link #getResponseId() <em>Response Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseId()
	 * @generated
	 * @ordered
	 */
	protected static final String RESPONSE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResponseId() <em>Response Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseId()
	 * @generated
	 * @ordered
	 */
	protected String responseId = RESPONSE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getModelVersion() <em>Model Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModelVersion() <em>Model Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModelVersion()
	 * @generated
	 * @ordered
	 */
	protected String modelVersion = MODEL_VERSION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCandidates() <em>Candidates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCandidates()
	 * @generated
	 * @ordered
	 */
	protected EList<Candidate> candidates;

	/**
	 * The cached value of the '{@link #getUsageMetadata() <em>Usage Metadata</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsageMetadata()
	 * @generated
	 * @ordered
	 */
	protected UsageMetadata usageMetadata;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeminiChatCompletionResponseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GeminiChatCompletionPackage.Literals.GEMINI_CHAT_COMPLETION_RESPONSE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getResponseId() {
		return responseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResponseId(String newResponseId) {
		String oldResponseId = responseId;
		responseId = newResponseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID, oldResponseId, responseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getModelVersion() {
		return modelVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModelVersion(String newModelVersion) {
		String oldModelVersion = modelVersion;
		modelVersion = newModelVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION, oldModelVersion, modelVersion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Candidate> getCandidates() {
		if (candidates == null) {
			candidates = new EObjectContainmentEList<Candidate>(Candidate.class, this, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES);
		}
		return candidates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public UsageMetadata getUsageMetadata() {
		return usageMetadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUsageMetadata(UsageMetadata newUsageMetadata, NotificationChain msgs) {
		UsageMetadata oldUsageMetadata = usageMetadata;
		usageMetadata = newUsageMetadata;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA, oldUsageMetadata, newUsageMetadata);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUsageMetadata(UsageMetadata newUsageMetadata) {
		if (newUsageMetadata != usageMetadata) {
			NotificationChain msgs = null;
			if (usageMetadata != null)
				msgs = ((InternalEObject)usageMetadata).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA, null, msgs);
			if (newUsageMetadata != null)
				msgs = ((InternalEObject)newUsageMetadata).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA, null, msgs);
			msgs = basicSetUsageMetadata(newUsageMetadata, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA, newUsageMetadata, newUsageMetadata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES:
				return ((InternalEList<?>)getCandidates()).basicRemove(otherEnd, msgs);
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA:
				return basicSetUsageMetadata(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID:
				return getResponseId();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION:
				return getModelVersion();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES:
				return getCandidates();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA:
				return getUsageMetadata();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID:
				setResponseId((String)newValue);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION:
				setModelVersion((String)newValue);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES:
				getCandidates().clear();
				getCandidates().addAll((Collection<? extends Candidate>)newValue);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA:
				setUsageMetadata((UsageMetadata)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID:
				setResponseId(RESPONSE_ID_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION:
				setModelVersion(MODEL_VERSION_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES:
				getCandidates().clear();
				return;
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA:
				setUsageMetadata((UsageMetadata)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__RESPONSE_ID:
				return RESPONSE_ID_EDEFAULT == null ? responseId != null : !RESPONSE_ID_EDEFAULT.equals(responseId);
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__MODEL_VERSION:
				return MODEL_VERSION_EDEFAULT == null ? modelVersion != null : !MODEL_VERSION_EDEFAULT.equals(modelVersion);
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__CANDIDATES:
				return candidates != null && !candidates.isEmpty();
			case GeminiChatCompletionPackage.GEMINI_CHAT_COMPLETION_RESPONSE__USAGE_METADATA:
				return usageMetadata != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (responseId: ");
		result.append(responseId);
		result.append(", modelVersion: ");
		result.append(modelVersion);
		result.append(')');
		return result.toString();
	}

} //GeminiChatCompletionResponseImpl
