/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GenerationConfig;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Generation Config</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl#getResponseMimeType <em>Response Mime Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.GenerationConfigImpl#getResponseJsonSchema <em>Response Json Schema</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GenerationConfigImpl extends MinimalEObjectImpl.Container implements GenerationConfig {
	/**
	 * The default value of the '{@link #getResponseMimeType() <em>Response Mime Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseMimeType()
	 * @generated
	 * @ordered
	 */
	protected static final String RESPONSE_MIME_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResponseMimeType() <em>Response Mime Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseMimeType()
	 * @generated
	 * @ordered
	 */
	protected String responseMimeType = RESPONSE_MIME_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getResponseJsonSchema() <em>Response Json Schema</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseJsonSchema()
	 * @generated
	 * @ordered
	 */
	protected JsonSchema responseJsonSchema;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenerationConfigImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GeminiChatCompletionPackage.Literals.GENERATION_CONFIG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getResponseMimeType() {
		return responseMimeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResponseMimeType(String newResponseMimeType) {
		String oldResponseMimeType = responseMimeType;
		responseMimeType = newResponseMimeType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_MIME_TYPE, oldResponseMimeType, responseMimeType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JsonSchema getResponseJsonSchema() {
		return responseJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResponseJsonSchema(JsonSchema newResponseJsonSchema, NotificationChain msgs) {
		JsonSchema oldResponseJsonSchema = responseJsonSchema;
		responseJsonSchema = newResponseJsonSchema;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA, oldResponseJsonSchema, newResponseJsonSchema);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResponseJsonSchema(JsonSchema newResponseJsonSchema) {
		if (newResponseJsonSchema != responseJsonSchema) {
			NotificationChain msgs = null;
			if (responseJsonSchema != null)
				msgs = ((InternalEObject)responseJsonSchema).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA, null, msgs);
			if (newResponseJsonSchema != null)
				msgs = ((InternalEObject)newResponseJsonSchema).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA, null, msgs);
			msgs = basicSetResponseJsonSchema(newResponseJsonSchema, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA, newResponseJsonSchema, newResponseJsonSchema));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA:
				return basicSetResponseJsonSchema(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_MIME_TYPE:
				return getResponseMimeType();
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA:
				return getResponseJsonSchema();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_MIME_TYPE:
				setResponseMimeType((String)newValue);
				return;
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA:
				setResponseJsonSchema((JsonSchema)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_MIME_TYPE:
				setResponseMimeType(RESPONSE_MIME_TYPE_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA:
				setResponseJsonSchema((JsonSchema)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_MIME_TYPE:
				return RESPONSE_MIME_TYPE_EDEFAULT == null ? responseMimeType != null : !RESPONSE_MIME_TYPE_EDEFAULT.equals(responseMimeType);
			case GeminiChatCompletionPackage.GENERATION_CONFIG__RESPONSE_JSON_SCHEMA:
				return responseJsonSchema != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (responseMimeType: ");
		result.append(responseMimeType);
		result.append(')');
		return result.toString();
	}

} //GenerationConfigImpl
