/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.GeminiChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.PromptTokensDetail;
import org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.UsageMetadata;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Usage Metadata</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl#getPromptTokenCount <em>Prompt Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl#getCandidatesTokenCount <em>Candidates Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl#getTotalTokenCount <em>Total Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl#getThoughtsTokenCount <em>Thoughts Token Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.geminichatcompletion.impl.UsageMetadataImpl#getPromptTokensDetails <em>Prompt Tokens Details</em>}</li>
 * </ul>
 *
 * @generated
 */
public class UsageMetadataImpl extends MinimalEObjectImpl.Container implements UsageMetadata {
	/**
	 * The default value of the '{@link #getPromptTokenCount() <em>Prompt Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokenCount()
	 * @generated
	 * @ordered
	 */
	protected static final int PROMPT_TOKEN_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPromptTokenCount() <em>Prompt Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokenCount()
	 * @generated
	 * @ordered
	 */
	protected int promptTokenCount = PROMPT_TOKEN_COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getCandidatesTokenCount() <em>Candidates Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCandidatesTokenCount()
	 * @generated
	 * @ordered
	 */
	protected static final int CANDIDATES_TOKEN_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCandidatesTokenCount() <em>Candidates Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCandidatesTokenCount()
	 * @generated
	 * @ordered
	 */
	protected int candidatesTokenCount = CANDIDATES_TOKEN_COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalTokenCount() <em>Total Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalTokenCount()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_TOKEN_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalTokenCount() <em>Total Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalTokenCount()
	 * @generated
	 * @ordered
	 */
	protected int totalTokenCount = TOTAL_TOKEN_COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getThoughtsTokenCount() <em>Thoughts Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThoughtsTokenCount()
	 * @generated
	 * @ordered
	 */
	protected static final int THOUGHTS_TOKEN_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getThoughtsTokenCount() <em>Thoughts Token Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThoughtsTokenCount()
	 * @generated
	 * @ordered
	 */
	protected int thoughtsTokenCount = THOUGHTS_TOKEN_COUNT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPromptTokensDetails() <em>Prompt Tokens Details</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokensDetails()
	 * @generated
	 * @ordered
	 */
	protected EList<PromptTokensDetail> promptTokensDetails;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsageMetadataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GeminiChatCompletionPackage.Literals.USAGE_METADATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPromptTokenCount() {
		return promptTokenCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPromptTokenCount(int newPromptTokenCount) {
		int oldPromptTokenCount = promptTokenCount;
		promptTokenCount = newPromptTokenCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKEN_COUNT, oldPromptTokenCount, promptTokenCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCandidatesTokenCount() {
		return candidatesTokenCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCandidatesTokenCount(int newCandidatesTokenCount) {
		int oldCandidatesTokenCount = candidatesTokenCount;
		candidatesTokenCount = newCandidatesTokenCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.USAGE_METADATA__CANDIDATES_TOKEN_COUNT, oldCandidatesTokenCount, candidatesTokenCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getTotalTokenCount() {
		return totalTokenCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTotalTokenCount(int newTotalTokenCount) {
		int oldTotalTokenCount = totalTokenCount;
		totalTokenCount = newTotalTokenCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.USAGE_METADATA__TOTAL_TOKEN_COUNT, oldTotalTokenCount, totalTokenCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getThoughtsTokenCount() {
		return thoughtsTokenCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setThoughtsTokenCount(int newThoughtsTokenCount) {
		int oldThoughtsTokenCount = thoughtsTokenCount;
		thoughtsTokenCount = newThoughtsTokenCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GeminiChatCompletionPackage.USAGE_METADATA__THOUGHTS_TOKEN_COUNT, oldThoughtsTokenCount, thoughtsTokenCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PromptTokensDetail> getPromptTokensDetails() {
		if (promptTokensDetails == null) {
			promptTokensDetails = new EObjectContainmentEList<PromptTokensDetail>(PromptTokensDetail.class, this, GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS);
		}
		return promptTokensDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS:
				return ((InternalEList<?>)getPromptTokensDetails()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKEN_COUNT:
				return getPromptTokenCount();
			case GeminiChatCompletionPackage.USAGE_METADATA__CANDIDATES_TOKEN_COUNT:
				return getCandidatesTokenCount();
			case GeminiChatCompletionPackage.USAGE_METADATA__TOTAL_TOKEN_COUNT:
				return getTotalTokenCount();
			case GeminiChatCompletionPackage.USAGE_METADATA__THOUGHTS_TOKEN_COUNT:
				return getThoughtsTokenCount();
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS:
				return getPromptTokensDetails();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKEN_COUNT:
				setPromptTokenCount((Integer)newValue);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__CANDIDATES_TOKEN_COUNT:
				setCandidatesTokenCount((Integer)newValue);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__TOTAL_TOKEN_COUNT:
				setTotalTokenCount((Integer)newValue);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__THOUGHTS_TOKEN_COUNT:
				setThoughtsTokenCount((Integer)newValue);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS:
				getPromptTokensDetails().clear();
				getPromptTokensDetails().addAll((Collection<? extends PromptTokensDetail>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKEN_COUNT:
				setPromptTokenCount(PROMPT_TOKEN_COUNT_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__CANDIDATES_TOKEN_COUNT:
				setCandidatesTokenCount(CANDIDATES_TOKEN_COUNT_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__TOTAL_TOKEN_COUNT:
				setTotalTokenCount(TOTAL_TOKEN_COUNT_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__THOUGHTS_TOKEN_COUNT:
				setThoughtsTokenCount(THOUGHTS_TOKEN_COUNT_EDEFAULT);
				return;
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS:
				getPromptTokensDetails().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKEN_COUNT:
				return promptTokenCount != PROMPT_TOKEN_COUNT_EDEFAULT;
			case GeminiChatCompletionPackage.USAGE_METADATA__CANDIDATES_TOKEN_COUNT:
				return candidatesTokenCount != CANDIDATES_TOKEN_COUNT_EDEFAULT;
			case GeminiChatCompletionPackage.USAGE_METADATA__TOTAL_TOKEN_COUNT:
				return totalTokenCount != TOTAL_TOKEN_COUNT_EDEFAULT;
			case GeminiChatCompletionPackage.USAGE_METADATA__THOUGHTS_TOKEN_COUNT:
				return thoughtsTokenCount != THOUGHTS_TOKEN_COUNT_EDEFAULT;
			case GeminiChatCompletionPackage.USAGE_METADATA__PROMPT_TOKENS_DETAILS:
				return promptTokensDetails != null && !promptTokensDetails.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (promptTokenCount: ");
		result.append(promptTokenCount);
		result.append(", candidatesTokenCount: ");
		result.append(candidatesTokenCount);
		result.append(", totalTokenCount: ");
		result.append(totalTokenCount);
		result.append(", thoughtsTokenCount: ");
		result.append(thoughtsTokenCount);
		result.append(')');
		return result.toString();
	}

} //UsageMetadataImpl
