/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.gecko.emf.json.constants.EMFJs;

/**
 * 
 * @author ilenia
 * @since Jun 10, 2025
 */
public class ChatCompletionHelper {

	private static final Logger LOGGER = Logger.getLogger(ChatCompletionHelper.class.getName());
	
	public static EObject convertToEClass(String value, EClass resultEClass, ResourceSet resSet) {

		if(value == null) return null;
		try {
			Resource res = resSet.createResource(URI.createURI(UUID.randomUUID().toString()), "application/json");
			Map<String, Object> options = new HashMap<>();
			options.put(EMFJs.OPTION_ROOT_ELEMENT, resultEClass);
			res.load(new ByteArrayInputStream(value.getBytes()), options);
			if(res.getContents() != null && !res.getContents().isEmpty()) {
				EObject obj = res.getContents().get(0);
				return obj;
			} else {
				LOGGER.severe(String.format("No content in loaded res"));
			}
		} catch(IOException e) {
			LOGGER.severe(String.format("IOException while loading EObject from String: %s", e));
		}		
		return null;
	}
	
	public static void sendChatCompletionRequest(String url, EObject request, Map<String, Object> options, ResourceSet resSet) {		
		try {
			Resource requestRes = resSet.createResource(URI.createURI(url), "application/json");
			requestRes.getContents().add(request);
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			requestRes.save(os, options);
			LOGGER.fine("Chat completion request payload: " + new String(os.toByteArray()));
			requestRes.save(options);			
			LOGGER.info("Chat completion request sent to: " + url);
		} catch(IOException e) {
			LOGGER.severe(String.format("IOException while sending request to Gemini: %s", e));
			e.printStackTrace();
		}
	}

}
