/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel complianceLevel='17.0' oSGiCompatible='true' basePackage='org.eclipse.fennec.ai.chat.completion.model' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation'"
 * @generated
 */
@ProviderType
@EPackage(uri = ChatCompletionPackage.eNS_URI, genModel = "/model/chat-completion.genmodel", genModelSourceLocations = {"model/chat-completion.genmodel","org.eclipse.fennec.ai.chat.completion.model/model/chat-completion.genmodel"}, ecore="/model/chat-completion.ecore", ecoreSourceLocations="/model/chat-completion.ecore")
public interface ChatCompletionPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "chatcompletion";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://eclipse.org/fennec/ai/chatcompletion/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "chatcompletion";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ChatCompletionPackage eINSTANCE = org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl <em>Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChatCompletionRequest()
	 * @generated
	 */
	int CHAT_COMPLETION_REQUEST = 0;

	/**
	 * The feature id for the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_REQUEST__MODEL = 0;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_REQUEST__MESSAGES = 1;

	/**
	 * The feature id for the '<em><b>Response Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT = 2;

	/**
	 * The number of structural features of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_REQUEST_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_REQUEST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.MessageImpl <em>Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.MessageImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getMessage()
	 * @generated
	 */
	int MESSAGE = 1;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ROLE = 0;

	/**
	 * The feature id for the '<em><b>Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__CONTENT = 1;

	/**
	 * The feature id for the '<em><b>Refusal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__REFUSAL = 2;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ANNOTATIONS = 3;

	/**
	 * The number of structural features of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ResponseFormatImpl <em>Response Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ResponseFormatImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getResponseFormat()
	 * @generated
	 */
	int RESPONSE_FORMAT = 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FORMAT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Json Schema</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FORMAT__JSON_SCHEMA = 1;

	/**
	 * The number of structural features of the '<em>Response Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FORMAT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Response Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FORMAT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl <em>Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChatCompletionResponse()
	 * @generated
	 */
	int CHAT_COMPLETION_RESPONSE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__ID = 0;

	/**
	 * The feature id for the '<em><b>Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__OBJECT = 1;

	/**
	 * The feature id for the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__MODEL = 2;

	/**
	 * The feature id for the '<em><b>Created</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__CREATED = 3;

	/**
	 * The feature id for the '<em><b>Choices</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__CHOICES = 4;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__USAGE = 5;

	/**
	 * The feature id for the '<em><b>Service Tier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__SERVICE_TIER = 6;

	/**
	 * The feature id for the '<em><b>System Fingerprint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT = 7;

	/**
	 * The number of structural features of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAT_COMPLETION_RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChoiceImpl <em>Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChoice()
	 * @generated
	 */
	int CHOICE = 4;

	/**
	 * The feature id for the '<em><b>Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__INDEX = 0;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__MESSAGE = 1;

	/**
	 * The feature id for the '<em><b>Logprobs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__LOGPROBS = 2;

	/**
	 * The feature id for the '<em><b>Finish Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE__FINISH_REASON = 3;

	/**
	 * The number of structural features of the '<em>Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl <em>Usage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getUsage()
	 * @generated
	 */
	int USAGE = 5;

	/**
	 * The feature id for the '<em><b>Prompt Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__PROMPT_TOKENS = 0;

	/**
	 * The feature id for the '<em><b>Completion Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__COMPLETION_TOKENS = 1;

	/**
	 * The feature id for the '<em><b>Total Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__TOTAL_TOKENS = 2;

	/**
	 * The feature id for the '<em><b>Prompt Token Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__PROMPT_TOKEN_DETAILS = 3;

	/**
	 * The feature id for the '<em><b>Completion Token Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__COMPLETION_TOKEN_DETAILS = 4;

	/**
	 * The number of structural features of the '<em>Usage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Usage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.PromptTokenDetailsImpl <em>Prompt Token Details</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.PromptTokenDetailsImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getPromptTokenDetails()
	 * @generated
	 */
	int PROMPT_TOKEN_DETAILS = 6;

	/**
	 * The feature id for the '<em><b>Cached Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKEN_DETAILS__CACHED_TOKENS = 0;

	/**
	 * The feature id for the '<em><b>Audio Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKEN_DETAILS__AUDIO_TOKENS = 1;

	/**
	 * The number of structural features of the '<em>Prompt Token Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKEN_DETAILS_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Prompt Token Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROMPT_TOKEN_DETAILS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl <em>Completion Tokens Details</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getCompletionTokensDetails()
	 * @generated
	 */
	int COMPLETION_TOKENS_DETAILS = 7;

	/**
	 * The feature id for the '<em><b>Reasoning Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS__REASONING_TOKENS = 0;

	/**
	 * The feature id for the '<em><b>Audio Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS = 1;

	/**
	 * The feature id for the '<em><b>Accepted Prediction Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS = 2;

	/**
	 * The feature id for the '<em><b>Rejected Prediction Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS = 3;

	/**
	 * The number of structural features of the '<em>Completion Tokens Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Completion Tokens Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLETION_TOKENS_DETAILS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.SchemaImpl <em>Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.SchemaImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getSchema()
	 * @generated
	 */
	int SCHEMA = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__NAME = 0;

	/**
	 * The feature id for the '<em><b>Strict</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__STRICT = 1;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__SCHEMA = 2;

	/**
	 * The number of structural features of the '<em>Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest <em>Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest
	 * @generated
	 */
	EClass getChatCompletionRequest();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getModel()
	 * @see #getChatCompletionRequest()
	 * @generated
	 */
	EAttribute getChatCompletionRequest_Model();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Messages</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getMessages()
	 * @see #getChatCompletionRequest()
	 * @generated
	 */
	EReference getChatCompletionRequest_Messages();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getResponseFormat <em>Response Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Response Format</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getResponseFormat()
	 * @see #getChatCompletionRequest()
	 * @generated
	 */
	EReference getChatCompletionRequest_ResponseFormat();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message
	 * @generated
	 */
	EClass getMessage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRole()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getContent()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRefusal <em>Refusal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Refusal</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRefusal()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_Refusal();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Annotations</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getAnnotations()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_Annotations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat <em>Response Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response Format</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat
	 * @generated
	 */
	EClass getResponseFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat#getType()
	 * @see #getResponseFormat()
	 * @generated
	 */
	EAttribute getResponseFormat_Type();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat#getJsonSchema <em>Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat#getJsonSchema()
	 * @see #getResponseFormat()
	 * @generated
	 */
	EReference getResponseFormat_JsonSchema();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse
	 * @generated
	 */
	EClass getChatCompletionResponse();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getId()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Object</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getObject()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_Object();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getModel()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_Model();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getCreated <em>Created</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Created</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getCreated()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_Created();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getChoices <em>Choices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Choices</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getChoices()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EReference getChatCompletionResponse_Choices();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getUsage <em>Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Usage</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getUsage()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EReference getChatCompletionResponse_Usage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getServiceTier <em>Service Tier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service Tier</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getServiceTier()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_ServiceTier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getSystemFingerprint <em>System Fingerprint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>System Fingerprint</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse#getSystemFingerprint()
	 * @see #getChatCompletionResponse()
	 * @generated
	 */
	EAttribute getChatCompletionResponse_SystemFingerprint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice <em>Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice
	 * @generated
	 */
	EClass getChoice();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getIndex <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Index</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getIndex()
	 * @see #getChoice()
	 * @generated
	 */
	EAttribute getChoice_Index();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Message</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getMessage()
	 * @see #getChoice()
	 * @generated
	 */
	EReference getChoice_Message();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getLogprobs <em>Logprobs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Logprobs</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getLogprobs()
	 * @see #getChoice()
	 * @generated
	 */
	EAttribute getChoice_Logprobs();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getFinishReason <em>Finish Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Finish Reason</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice#getFinishReason()
	 * @see #getChoice()
	 * @generated
	 */
	EAttribute getChoice_FinishReason();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage <em>Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Usage</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage
	 * @generated
	 */
	EClass getUsage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokens <em>Prompt Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Prompt Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_PromptTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokens <em>Completion Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Completion Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_CompletionTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getTotalTokens <em>Total Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getTotalTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_TotalTokens();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokenDetails <em>Prompt Token Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Prompt Token Details</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokenDetails()
	 * @see #getUsage()
	 * @generated
	 */
	EReference getUsage_PromptTokenDetails();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokenDetails <em>Completion Token Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Completion Token Details</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokenDetails()
	 * @see #getUsage()
	 * @generated
	 */
	EReference getUsage_CompletionTokenDetails();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails <em>Prompt Token Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Prompt Token Details</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails
	 * @generated
	 */
	EClass getPromptTokenDetails();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getCachedTokens <em>Cached Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cached Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getCachedTokens()
	 * @see #getPromptTokenDetails()
	 * @generated
	 */
	EAttribute getPromptTokenDetails_CachedTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getAudioTokens <em>Audio Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Audio Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getAudioTokens()
	 * @see #getPromptTokenDetails()
	 * @generated
	 */
	EAttribute getPromptTokenDetails_AudioTokens();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails <em>Completion Tokens Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Completion Tokens Details</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails
	 * @generated
	 */
	EClass getCompletionTokensDetails();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getReasoningTokens <em>Reasoning Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reasoning Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getReasoningTokens()
	 * @see #getCompletionTokensDetails()
	 * @generated
	 */
	EAttribute getCompletionTokensDetails_ReasoningTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAudioTokens <em>Audio Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Audio Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAudioTokens()
	 * @see #getCompletionTokensDetails()
	 * @generated
	 */
	EAttribute getCompletionTokensDetails_AudioTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAcceptedPredictionTokens <em>Accepted Prediction Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Accepted Prediction Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAcceptedPredictionTokens()
	 * @see #getCompletionTokensDetails()
	 * @generated
	 */
	EAttribute getCompletionTokensDetails_AcceptedPredictionTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getRejectedPredictionTokens <em>Rejected Prediction Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rejected Prediction Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getRejectedPredictionTokens()
	 * @see #getCompletionTokensDetails()
	 * @generated
	 */
	EAttribute getCompletionTokensDetails_RejectedPredictionTokens();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema
	 * @generated
	 */
	EClass getSchema();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getName()
	 * @see #getSchema()
	 * @generated
	 */
	EAttribute getSchema_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#isStrict <em>Strict</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Strict</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#isStrict()
	 * @see #getSchema()
	 * @generated
	 */
	EAttribute getSchema_Strict();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getSchema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getSchema()
	 * @see #getSchema()
	 * @generated
	 */
	EReference getSchema_Schema();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ChatCompletionFactory getChatCompletionFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl <em>Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChatCompletionRequest()
		 * @generated
		 */
		EClass CHAT_COMPLETION_REQUEST = eINSTANCE.getChatCompletionRequest();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_REQUEST__MODEL = eINSTANCE.getChatCompletionRequest_Model();

		/**
		 * The meta object literal for the '<em><b>Messages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHAT_COMPLETION_REQUEST__MESSAGES = eINSTANCE.getChatCompletionRequest_Messages();

		/**
		 * The meta object literal for the '<em><b>Response Format</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT = eINSTANCE.getChatCompletionRequest_ResponseFormat();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.MessageImpl <em>Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.MessageImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getMessage()
		 * @generated
		 */
		EClass MESSAGE = eINSTANCE.getMessage();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__ROLE = eINSTANCE.getMessage_Role();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__CONTENT = eINSTANCE.getMessage_Content();

		/**
		 * The meta object literal for the '<em><b>Refusal</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__REFUSAL = eINSTANCE.getMessage_Refusal();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__ANNOTATIONS = eINSTANCE.getMessage_Annotations();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ResponseFormatImpl <em>Response Format</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ResponseFormatImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getResponseFormat()
		 * @generated
		 */
		EClass RESPONSE_FORMAT = eINSTANCE.getResponseFormat();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESPONSE_FORMAT__TYPE = eINSTANCE.getResponseFormat_Type();

		/**
		 * The meta object literal for the '<em><b>Json Schema</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESPONSE_FORMAT__JSON_SCHEMA = eINSTANCE.getResponseFormat_JsonSchema();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl <em>Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChatCompletionResponse()
		 * @generated
		 */
		EClass CHAT_COMPLETION_RESPONSE = eINSTANCE.getChatCompletionResponse();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__ID = eINSTANCE.getChatCompletionResponse_Id();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__OBJECT = eINSTANCE.getChatCompletionResponse_Object();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__MODEL = eINSTANCE.getChatCompletionResponse_Model();

		/**
		 * The meta object literal for the '<em><b>Created</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__CREATED = eINSTANCE.getChatCompletionResponse_Created();

		/**
		 * The meta object literal for the '<em><b>Choices</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHAT_COMPLETION_RESPONSE__CHOICES = eINSTANCE.getChatCompletionResponse_Choices();

		/**
		 * The meta object literal for the '<em><b>Usage</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHAT_COMPLETION_RESPONSE__USAGE = eINSTANCE.getChatCompletionResponse_Usage();

		/**
		 * The meta object literal for the '<em><b>Service Tier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__SERVICE_TIER = eINSTANCE.getChatCompletionResponse_ServiceTier();

		/**
		 * The meta object literal for the '<em><b>System Fingerprint</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT = eINSTANCE.getChatCompletionResponse_SystemFingerprint();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChoiceImpl <em>Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getChoice()
		 * @generated
		 */
		EClass CHOICE = eINSTANCE.getChoice();

		/**
		 * The meta object literal for the '<em><b>Index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHOICE__INDEX = eINSTANCE.getChoice_Index();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHOICE__MESSAGE = eINSTANCE.getChoice_Message();

		/**
		 * The meta object literal for the '<em><b>Logprobs</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHOICE__LOGPROBS = eINSTANCE.getChoice_Logprobs();

		/**
		 * The meta object literal for the '<em><b>Finish Reason</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHOICE__FINISH_REASON = eINSTANCE.getChoice_FinishReason();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl <em>Usage</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getUsage()
		 * @generated
		 */
		EClass USAGE = eINSTANCE.getUsage();

		/**
		 * The meta object literal for the '<em><b>Prompt Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__PROMPT_TOKENS = eINSTANCE.getUsage_PromptTokens();

		/**
		 * The meta object literal for the '<em><b>Completion Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__COMPLETION_TOKENS = eINSTANCE.getUsage_CompletionTokens();

		/**
		 * The meta object literal for the '<em><b>Total Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__TOTAL_TOKENS = eINSTANCE.getUsage_TotalTokens();

		/**
		 * The meta object literal for the '<em><b>Prompt Token Details</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USAGE__PROMPT_TOKEN_DETAILS = eINSTANCE.getUsage_PromptTokenDetails();

		/**
		 * The meta object literal for the '<em><b>Completion Token Details</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USAGE__COMPLETION_TOKEN_DETAILS = eINSTANCE.getUsage_CompletionTokenDetails();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.PromptTokenDetailsImpl <em>Prompt Token Details</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.PromptTokenDetailsImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getPromptTokenDetails()
		 * @generated
		 */
		EClass PROMPT_TOKEN_DETAILS = eINSTANCE.getPromptTokenDetails();

		/**
		 * The meta object literal for the '<em><b>Cached Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROMPT_TOKEN_DETAILS__CACHED_TOKENS = eINSTANCE.getPromptTokenDetails_CachedTokens();

		/**
		 * The meta object literal for the '<em><b>Audio Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROMPT_TOKEN_DETAILS__AUDIO_TOKENS = eINSTANCE.getPromptTokenDetails_AudioTokens();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl <em>Completion Tokens Details</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getCompletionTokensDetails()
		 * @generated
		 */
		EClass COMPLETION_TOKENS_DETAILS = eINSTANCE.getCompletionTokensDetails();

		/**
		 * The meta object literal for the '<em><b>Reasoning Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPLETION_TOKENS_DETAILS__REASONING_TOKENS = eINSTANCE.getCompletionTokensDetails_ReasoningTokens();

		/**
		 * The meta object literal for the '<em><b>Audio Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS = eINSTANCE.getCompletionTokensDetails_AudioTokens();

		/**
		 * The meta object literal for the '<em><b>Accepted Prediction Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS = eINSTANCE.getCompletionTokensDetails_AcceptedPredictionTokens();

		/**
		 * The meta object literal for the '<em><b>Rejected Prediction Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS = eINSTANCE.getCompletionTokensDetails_RejectedPredictionTokens();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.SchemaImpl <em>Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.SchemaImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionPackageImpl#getSchema()
		 * @generated
		 */
		EClass SCHEMA = eINSTANCE.getSchema();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEMA__NAME = eINSTANCE.getSchema_Name();

		/**
		 * The meta object literal for the '<em><b>Strict</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEMA__STRICT = eINSTANCE.getSchema_Strict();

		/**
		 * The meta object literal for the '<em><b>Schema</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEMA__SCHEMA = eINSTANCE.getSchema_Schema();

	}

} //ChatCompletionPackage
