/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Request</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getResponseFormat <em>Response Format</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getChatCompletionRequest()
 * @model
 * @generated
 */
@ProviderType
public interface ChatCompletionRequest extends EObject {
	/**
	 * Returns the value of the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model</em>' attribute.
	 * @see #setModel(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getChatCompletionRequest_Model()
	 * @model
	 * @generated
	 */
	String getModel();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getModel <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model</em>' attribute.
	 * @see #getModel()
	 * @generated
	 */
	void setModel(String value);

	/**
	 * Returns the value of the '<em><b>Messages</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Messages</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getChatCompletionRequest_Messages()
	 * @model containment="true"
	 * @generated
	 */
	EList<Message> getMessages();

	/**
	 * Returns the value of the '<em><b>Response Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Response Format</em>' containment reference.
	 * @see #setResponseFormat(ResponseFormat)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getChatCompletionRequest_ResponseFormat()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='response_format'"
	 * @generated
	 */
	ResponseFormat getResponseFormat();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest#getResponseFormat <em>Response Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Response Format</em>' containment reference.
	 * @see #getResponseFormat()
	 * @generated
	 */
	void setResponseFormat(ResponseFormat value);

} // ChatCompletionRequest
