/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Completion Tokens Details</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getReasoningTokens <em>Reasoning Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAudioTokens <em>Audio Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAcceptedPredictionTokens <em>Accepted Prediction Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getRejectedPredictionTokens <em>Rejected Prediction Tokens</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getCompletionTokensDetails()
 * @model
 * @generated
 */
@ProviderType
public interface CompletionTokensDetails extends EObject {
	/**
	 * Returns the value of the '<em><b>Reasoning Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reasoning Tokens</em>' attribute.
	 * @see #setReasoningTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getCompletionTokensDetails_ReasoningTokens()
	 * @model extendedMetaData="kind='element' name='reasoning_tokens'"
	 * @generated
	 */
	int getReasoningTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getReasoningTokens <em>Reasoning Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reasoning Tokens</em>' attribute.
	 * @see #getReasoningTokens()
	 * @generated
	 */
	void setReasoningTokens(int value);

	/**
	 * Returns the value of the '<em><b>Audio Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Audio Tokens</em>' attribute.
	 * @see #setAudioTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getCompletionTokensDetails_AudioTokens()
	 * @model extendedMetaData="kind='element' name='audio_tokens'"
	 * @generated
	 */
	int getAudioTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAudioTokens <em>Audio Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Audio Tokens</em>' attribute.
	 * @see #getAudioTokens()
	 * @generated
	 */
	void setAudioTokens(int value);

	/**
	 * Returns the value of the '<em><b>Accepted Prediction Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Accepted Prediction Tokens</em>' attribute.
	 * @see #setAcceptedPredictionTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getCompletionTokensDetails_AcceptedPredictionTokens()
	 * @model extendedMetaData="kind='element' name='accepted_prediction_tokens'"
	 * @generated
	 */
	int getAcceptedPredictionTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getAcceptedPredictionTokens <em>Accepted Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Accepted Prediction Tokens</em>' attribute.
	 * @see #getAcceptedPredictionTokens()
	 * @generated
	 */
	void setAcceptedPredictionTokens(int value);

	/**
	 * Returns the value of the '<em><b>Rejected Prediction Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rejected Prediction Tokens</em>' attribute.
	 * @see #setRejectedPredictionTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getCompletionTokensDetails_RejectedPredictionTokens()
	 * @model extendedMetaData="kind='element' name='rejected_prediction_tokens'"
	 * @generated
	 */
	int getRejectedPredictionTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails#getRejectedPredictionTokens <em>Rejected Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rejected Prediction Tokens</em>' attribute.
	 * @see #getRejectedPredictionTokens()
	 * @generated
	 */
	void setRejectedPredictionTokens(int value);

} // CompletionTokensDetails
