/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Message</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRefusal <em>Refusal</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getAnnotations <em>Annotations</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getMessage()
 * @model
 * @generated
 */
@ProviderType
public interface Message extends EObject {
	/**
	 * Returns the value of the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Role</em>' attribute.
	 * @see #setRole(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getMessage_Role()
	 * @model
	 * @generated
	 */
	String getRole();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRole <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Role</em>' attribute.
	 * @see #getRole()
	 * @generated
	 */
	void setRole(String value);

	/**
	 * Returns the value of the '<em><b>Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Content</em>' attribute.
	 * @see #setContent(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getMessage_Content()
	 * @model
	 * @generated
	 */
	String getContent();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getContent <em>Content</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Content</em>' attribute.
	 * @see #getContent()
	 * @generated
	 */
	void setContent(String value);

	/**
	 * Returns the value of the '<em><b>Refusal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Refusal</em>' attribute.
	 * @see #setRefusal(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getMessage_Refusal()
	 * @model
	 * @generated
	 */
	String getRefusal();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message#getRefusal <em>Refusal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Refusal</em>' attribute.
	 * @see #getRefusal()
	 * @generated
	 */
	void setRefusal(String value);

	/**
	 * Returns the value of the '<em><b>Annotations</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Annotations</em>' attribute list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getMessage_Annotations()
	 * @model
	 * @generated
	 */
	EList<String> getAnnotations();

} // Message
