/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Prompt Token Details</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getCachedTokens <em>Cached Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getAudioTokens <em>Audio Tokens</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getPromptTokenDetails()
 * @model
 * @generated
 */
@ProviderType
public interface PromptTokenDetails extends EObject {
	/**
	 * Returns the value of the '<em><b>Cached Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Cached Tokens</em>' attribute.
	 * @see #setCachedTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getPromptTokenDetails_CachedTokens()
	 * @model extendedMetaData="kind='element' name='cached_tokens'"
	 * @generated
	 */
	int getCachedTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getCachedTokens <em>Cached Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cached Tokens</em>' attribute.
	 * @see #getCachedTokens()
	 * @generated
	 */
	void setCachedTokens(int value);

	/**
	 * Returns the value of the '<em><b>Audio Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Audio Tokens</em>' attribute.
	 * @see #setAudioTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getPromptTokenDetails_AudioTokens()
	 * @model extendedMetaData="kind='element' name='audio_tokens'"
	 * @generated
	 */
	int getAudioTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails#getAudioTokens <em>Audio Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Audio Tokens</em>' attribute.
	 * @see #getAudioTokens()
	 * @generated
	 */
	void setAudioTokens(int value);

} // PromptTokenDetails
