/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Schema</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#isStrict <em>Strict</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getSchema <em>Schema</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getSchema()
 * @model
 * @generated
 */
@ProviderType
public interface Schema extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getSchema_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Strict</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Strict</em>' attribute.
	 * @see #setStrict(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getSchema_Strict()
	 * @model default="true"
	 * @generated
	 */
	boolean isStrict();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#isStrict <em>Strict</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Strict</em>' attribute.
	 * @see #isStrict()
	 * @generated
	 */
	void setStrict(boolean value);

	/**
	 * Returns the value of the '<em><b>Schema</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Schema</em>' containment reference.
	 * @see #setSchema(JsonSchema)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getSchema_Schema()
	 * @model containment="true"
	 * @generated
	 */
	JsonSchema getSchema();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema#getSchema <em>Schema</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Schema</em>' containment reference.
	 * @see #getSchema()
	 * @generated
	 */
	void setSchema(JsonSchema value);

} // Schema
