/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Usage</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokens <em>Prompt Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokens <em>Completion Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getTotalTokens <em>Total Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokenDetails <em>Prompt Token Details</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokenDetails <em>Completion Token Details</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage()
 * @model
 * @generated
 */
@ProviderType
public interface Usage extends EObject {
	/**
	 * Returns the value of the '<em><b>Prompt Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prompt Tokens</em>' attribute.
	 * @see #setPromptTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage_PromptTokens()
	 * @model extendedMetaData="kind='element' name='prompt_tokens'"
	 * @generated
	 */
	int getPromptTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokens <em>Prompt Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Prompt Tokens</em>' attribute.
	 * @see #getPromptTokens()
	 * @generated
	 */
	void setPromptTokens(int value);

	/**
	 * Returns the value of the '<em><b>Completion Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Completion Tokens</em>' attribute.
	 * @see #setCompletionTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage_CompletionTokens()
	 * @model extendedMetaData="kind='element' name='completion_tokens'"
	 * @generated
	 */
	int getCompletionTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokens <em>Completion Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Completion Tokens</em>' attribute.
	 * @see #getCompletionTokens()
	 * @generated
	 */
	void setCompletionTokens(int value);

	/**
	 * Returns the value of the '<em><b>Total Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Total Tokens</em>' attribute.
	 * @see #setTotalTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage_TotalTokens()
	 * @model extendedMetaData="kind='element' name='total_tokens'"
	 * @generated
	 */
	int getTotalTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getTotalTokens <em>Total Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Tokens</em>' attribute.
	 * @see #getTotalTokens()
	 * @generated
	 */
	void setTotalTokens(int value);

	/**
	 * Returns the value of the '<em><b>Prompt Token Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prompt Token Details</em>' containment reference.
	 * @see #setPromptTokenDetails(PromptTokenDetails)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage_PromptTokenDetails()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='prompt_tokens_details'"
	 * @generated
	 */
	PromptTokenDetails getPromptTokenDetails();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getPromptTokenDetails <em>Prompt Token Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Prompt Token Details</em>' containment reference.
	 * @see #getPromptTokenDetails()
	 * @generated
	 */
	void setPromptTokenDetails(PromptTokenDetails value);

	/**
	 * Returns the value of the '<em><b>Completion Token Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Completion Token Details</em>' containment reference.
	 * @see #setCompletionTokenDetails(CompletionTokensDetails)
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#getUsage_CompletionTokenDetails()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='completion_tokens_details'"
	 * @generated
	 */
	CompletionTokensDetails getCompletionTokenDetails();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage#getCompletionTokenDetails <em>Completion Token Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Completion Token Details</em>' containment reference.
	 * @see #getCompletionTokenDetails()
	 * @generated
	 */
	void setCompletionTokenDetails(CompletionTokensDetails value);

} // Usage
