/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ChatCompletionFactoryImpl extends EFactoryImpl implements ChatCompletionFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ChatCompletionFactory init() {
		try {
			ChatCompletionFactory theChatCompletionFactory = (ChatCompletionFactory)EPackage.Registry.INSTANCE.getEFactory(ChatCompletionPackage.eNS_URI);
			if (theChatCompletionFactory != null) {
				return theChatCompletionFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ChatCompletionFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ChatCompletionFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST: return createChatCompletionRequest();
			case ChatCompletionPackage.MESSAGE: return createMessage();
			case ChatCompletionPackage.RESPONSE_FORMAT: return createResponseFormat();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE: return createChatCompletionResponse();
			case ChatCompletionPackage.CHOICE: return createChoice();
			case ChatCompletionPackage.USAGE: return createUsage();
			case ChatCompletionPackage.PROMPT_TOKEN_DETAILS: return createPromptTokenDetails();
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS: return createCompletionTokensDetails();
			case ChatCompletionPackage.SCHEMA: return createSchema();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChatCompletionRequest createChatCompletionRequest() {
		ChatCompletionRequestImpl chatCompletionRequest = new ChatCompletionRequestImpl();
		return chatCompletionRequest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Message createMessage() {
		MessageImpl message = new MessageImpl();
		return message;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResponseFormat createResponseFormat() {
		ResponseFormatImpl responseFormat = new ResponseFormatImpl();
		return responseFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChatCompletionResponse createChatCompletionResponse() {
		ChatCompletionResponseImpl chatCompletionResponse = new ChatCompletionResponseImpl();
		return chatCompletionResponse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Choice createChoice() {
		ChoiceImpl choice = new ChoiceImpl();
		return choice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Usage createUsage() {
		UsageImpl usage = new UsageImpl();
		return usage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PromptTokenDetails createPromptTokenDetails() {
		PromptTokenDetailsImpl promptTokenDetails = new PromptTokenDetailsImpl();
		return promptTokenDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CompletionTokensDetails createCompletionTokensDetails() {
		CompletionTokensDetailsImpl completionTokensDetails = new CompletionTokensDetailsImpl();
		return completionTokensDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Schema createSchema() {
		SchemaImpl schema = new SchemaImpl();
		return schema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChatCompletionPackage getChatCompletionPackage() {
		return (ChatCompletionPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ChatCompletionPackage getPackage() {
		return ChatCompletionPackage.eINSTANCE;
	}

} //ChatCompletionFactoryImpl
