/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionFactory;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Schema;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ChatCompletionPackageImpl extends EPackageImpl implements ChatCompletionPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass chatCompletionRequestEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass messageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass responseFormatEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass chatCompletionResponseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass choiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass usageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass promptTokenDetailsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass completionTokensDetailsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass schemaEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ChatCompletionPackageImpl() {
		super(eNS_URI, ChatCompletionFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link ChatCompletionPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ChatCompletionPackage init() {
		if (isInited) return (ChatCompletionPackage)EPackage.Registry.INSTANCE.getEPackage(ChatCompletionPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredChatCompletionPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		ChatCompletionPackageImpl theChatCompletionPackage = registeredChatCompletionPackage instanceof ChatCompletionPackageImpl ? (ChatCompletionPackageImpl)registeredChatCompletionPackage : new ChatCompletionPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		JsonSchemaPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theChatCompletionPackage.createPackageContents();

		// Initialize created meta-data
		theChatCompletionPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theChatCompletionPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ChatCompletionPackage.eNS_URI, theChatCompletionPackage);
		return theChatCompletionPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChatCompletionRequest() {
		return chatCompletionRequestEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionRequest_Model() {
		return (EAttribute)chatCompletionRequestEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChatCompletionRequest_Messages() {
		return (EReference)chatCompletionRequestEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChatCompletionRequest_ResponseFormat() {
		return (EReference)chatCompletionRequestEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMessage() {
		return messageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMessage_Role() {
		return (EAttribute)messageEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMessage_Content() {
		return (EAttribute)messageEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMessage_Refusal() {
		return (EAttribute)messageEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMessage_Annotations() {
		return (EAttribute)messageEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getResponseFormat() {
		return responseFormatEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getResponseFormat_Type() {
		return (EAttribute)responseFormatEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getResponseFormat_JsonSchema() {
		return (EReference)responseFormatEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChatCompletionResponse() {
		return chatCompletionResponseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_Id() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_Object() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_Model() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_Created() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChatCompletionResponse_Choices() {
		return (EReference)chatCompletionResponseEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChatCompletionResponse_Usage() {
		return (EReference)chatCompletionResponseEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_ServiceTier() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChatCompletionResponse_SystemFingerprint() {
		return (EAttribute)chatCompletionResponseEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChoice() {
		return choiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChoice_Index() {
		return (EAttribute)choiceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChoice_Message() {
		return (EReference)choiceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChoice_Logprobs() {
		return (EAttribute)choiceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChoice_FinishReason() {
		return (EAttribute)choiceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getUsage() {
		return usageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_PromptTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_CompletionTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_TotalTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getUsage_PromptTokenDetails() {
		return (EReference)usageEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getUsage_CompletionTokenDetails() {
		return (EReference)usageEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPromptTokenDetails() {
		return promptTokenDetailsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPromptTokenDetails_CachedTokens() {
		return (EAttribute)promptTokenDetailsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPromptTokenDetails_AudioTokens() {
		return (EAttribute)promptTokenDetailsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCompletionTokensDetails() {
		return completionTokensDetailsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCompletionTokensDetails_ReasoningTokens() {
		return (EAttribute)completionTokensDetailsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCompletionTokensDetails_AudioTokens() {
		return (EAttribute)completionTokensDetailsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCompletionTokensDetails_AcceptedPredictionTokens() {
		return (EAttribute)completionTokensDetailsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCompletionTokensDetails_RejectedPredictionTokens() {
		return (EAttribute)completionTokensDetailsEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSchema() {
		return schemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchema_Name() {
		return (EAttribute)schemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSchema_Strict() {
		return (EAttribute)schemaEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getSchema_Schema() {
		return (EReference)schemaEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChatCompletionFactory getChatCompletionFactory() {
		return (ChatCompletionFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		chatCompletionRequestEClass = createEClass(CHAT_COMPLETION_REQUEST);
		createEAttribute(chatCompletionRequestEClass, CHAT_COMPLETION_REQUEST__MODEL);
		createEReference(chatCompletionRequestEClass, CHAT_COMPLETION_REQUEST__MESSAGES);
		createEReference(chatCompletionRequestEClass, CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT);

		messageEClass = createEClass(MESSAGE);
		createEAttribute(messageEClass, MESSAGE__ROLE);
		createEAttribute(messageEClass, MESSAGE__CONTENT);
		createEAttribute(messageEClass, MESSAGE__REFUSAL);
		createEAttribute(messageEClass, MESSAGE__ANNOTATIONS);

		responseFormatEClass = createEClass(RESPONSE_FORMAT);
		createEAttribute(responseFormatEClass, RESPONSE_FORMAT__TYPE);
		createEReference(responseFormatEClass, RESPONSE_FORMAT__JSON_SCHEMA);

		chatCompletionResponseEClass = createEClass(CHAT_COMPLETION_RESPONSE);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__ID);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__OBJECT);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__MODEL);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__CREATED);
		createEReference(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__CHOICES);
		createEReference(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__USAGE);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__SERVICE_TIER);
		createEAttribute(chatCompletionResponseEClass, CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT);

		choiceEClass = createEClass(CHOICE);
		createEAttribute(choiceEClass, CHOICE__INDEX);
		createEReference(choiceEClass, CHOICE__MESSAGE);
		createEAttribute(choiceEClass, CHOICE__LOGPROBS);
		createEAttribute(choiceEClass, CHOICE__FINISH_REASON);

		usageEClass = createEClass(USAGE);
		createEAttribute(usageEClass, USAGE__PROMPT_TOKENS);
		createEAttribute(usageEClass, USAGE__COMPLETION_TOKENS);
		createEAttribute(usageEClass, USAGE__TOTAL_TOKENS);
		createEReference(usageEClass, USAGE__PROMPT_TOKEN_DETAILS);
		createEReference(usageEClass, USAGE__COMPLETION_TOKEN_DETAILS);

		promptTokenDetailsEClass = createEClass(PROMPT_TOKEN_DETAILS);
		createEAttribute(promptTokenDetailsEClass, PROMPT_TOKEN_DETAILS__CACHED_TOKENS);
		createEAttribute(promptTokenDetailsEClass, PROMPT_TOKEN_DETAILS__AUDIO_TOKENS);

		completionTokensDetailsEClass = createEClass(COMPLETION_TOKENS_DETAILS);
		createEAttribute(completionTokensDetailsEClass, COMPLETION_TOKENS_DETAILS__REASONING_TOKENS);
		createEAttribute(completionTokensDetailsEClass, COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS);
		createEAttribute(completionTokensDetailsEClass, COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS);
		createEAttribute(completionTokensDetailsEClass, COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS);

		schemaEClass = createEClass(SCHEMA);
		createEAttribute(schemaEClass, SCHEMA__NAME);
		createEAttribute(schemaEClass, SCHEMA__STRICT);
		createEReference(schemaEClass, SCHEMA__SCHEMA);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		JsonSchemaPackage theJsonSchemaPackage = (JsonSchemaPackage)EPackage.Registry.INSTANCE.getEPackage(JsonSchemaPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(chatCompletionRequestEClass, ChatCompletionRequest.class, "ChatCompletionRequest", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChatCompletionRequest_Model(), ecorePackage.getEString(), "model", null, 0, 1, ChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChatCompletionRequest_Messages(), this.getMessage(), null, "messages", null, 0, -1, ChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChatCompletionRequest_ResponseFormat(), this.getResponseFormat(), null, "responseFormat", null, 0, 1, ChatCompletionRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(messageEClass, Message.class, "Message", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMessage_Role(), ecorePackage.getEString(), "role", null, 0, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMessage_Content(), ecorePackage.getEString(), "content", null, 0, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMessage_Refusal(), ecorePackage.getEString(), "refusal", null, 0, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMessage_Annotations(), ecorePackage.getEString(), "annotations", null, 0, -1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(responseFormatEClass, ResponseFormat.class, "ResponseFormat", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getResponseFormat_Type(), ecorePackage.getEString(), "type", null, 0, 1, ResponseFormat.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getResponseFormat_JsonSchema(), this.getSchema(), null, "jsonSchema", null, 0, 1, ResponseFormat.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(chatCompletionResponseEClass, ChatCompletionResponse.class, "ChatCompletionResponse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChatCompletionResponse_Id(), ecorePackage.getEString(), "id", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChatCompletionResponse_Object(), ecorePackage.getEString(), "object", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChatCompletionResponse_Model(), ecorePackage.getEString(), "model", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChatCompletionResponse_Created(), ecorePackage.getELong(), "created", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChatCompletionResponse_Choices(), this.getChoice(), null, "choices", null, 0, -1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChatCompletionResponse_Usage(), this.getUsage(), null, "usage", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChatCompletionResponse_ServiceTier(), ecorePackage.getEString(), "serviceTier", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChatCompletionResponse_SystemFingerprint(), ecorePackage.getEString(), "systemFingerprint", null, 0, 1, ChatCompletionResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(choiceEClass, Choice.class, "Choice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChoice_Index(), ecorePackage.getEInt(), "index", null, 0, 1, Choice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChoice_Message(), this.getMessage(), null, "message", null, 0, 1, Choice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChoice_Logprobs(), ecorePackage.getEString(), "logprobs", null, 0, 1, Choice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChoice_FinishReason(), ecorePackage.getEString(), "finishReason", null, 0, 1, Choice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(usageEClass, Usage.class, "Usage", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUsage_PromptTokens(), ecorePackage.getEInt(), "promptTokens", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsage_CompletionTokens(), ecorePackage.getEInt(), "completionTokens", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsage_TotalTokens(), ecorePackage.getEInt(), "totalTokens", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getUsage_PromptTokenDetails(), this.getPromptTokenDetails(), null, "promptTokenDetails", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getUsage_CompletionTokenDetails(), this.getCompletionTokensDetails(), null, "completionTokenDetails", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(promptTokenDetailsEClass, PromptTokenDetails.class, "PromptTokenDetails", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPromptTokenDetails_CachedTokens(), ecorePackage.getEInt(), "cachedTokens", null, 0, 1, PromptTokenDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPromptTokenDetails_AudioTokens(), ecorePackage.getEInt(), "audioTokens", null, 0, 1, PromptTokenDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(completionTokensDetailsEClass, CompletionTokensDetails.class, "CompletionTokensDetails", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCompletionTokensDetails_ReasoningTokens(), ecorePackage.getEInt(), "reasoningTokens", null, 0, 1, CompletionTokensDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCompletionTokensDetails_AudioTokens(), ecorePackage.getEInt(), "audioTokens", null, 0, 1, CompletionTokensDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCompletionTokensDetails_AcceptedPredictionTokens(), ecorePackage.getEInt(), "acceptedPredictionTokens", null, 0, 1, CompletionTokensDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCompletionTokensDetails_RejectedPredictionTokens(), ecorePackage.getEInt(), "rejectedPredictionTokens", null, 0, 1, CompletionTokensDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(schemaEClass, Schema.class, "Schema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSchema_Name(), ecorePackage.getEString(), "name", null, 0, 1, Schema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSchema_Strict(), ecorePackage.getEBoolean(), "strict", "true", 0, 1, Schema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSchema_Schema(), theJsonSchemaPackage.getJsonSchema(), null, "schema", null, 0, 1, Schema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "complianceLevel", "17.0",
			   "oSGiCompatible", "true",
			   "basePackage", "org.eclipse.fennec.ai.chat.completion.model",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation"
		   });
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
		addAnnotation
		  (getChatCompletionRequest_ResponseFormat(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "response_format"
		   });
		addAnnotation
		  (getResponseFormat_JsonSchema(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "json_schema"
		   });
		addAnnotation
		  (getChatCompletionResponse_ServiceTier(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "service_tier"
		   });
		addAnnotation
		  (getChatCompletionResponse_SystemFingerprint(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "system_fingerprint"
		   });
		addAnnotation
		  (getChoice_FinishReason(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "finish_reason"
		   });
		addAnnotation
		  (getUsage_PromptTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "prompt_tokens"
		   });
		addAnnotation
		  (getUsage_CompletionTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "completion_tokens"
		   });
		addAnnotation
		  (getUsage_TotalTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "total_tokens"
		   });
		addAnnotation
		  (getUsage_PromptTokenDetails(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "prompt_tokens_details"
		   });
		addAnnotation
		  (getUsage_CompletionTokenDetails(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "completion_tokens_details"
		   });
		addAnnotation
		  (getPromptTokenDetails_CachedTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "cached_tokens"
		   });
		addAnnotation
		  (getPromptTokenDetails_AudioTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "audio_tokens"
		   });
		addAnnotation
		  (getCompletionTokensDetails_ReasoningTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "reasoning_tokens"
		   });
		addAnnotation
		  (getCompletionTokensDetails_AudioTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "audio_tokens"
		   });
		addAnnotation
		  (getCompletionTokensDetails_AcceptedPredictionTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "accepted_prediction_tokens"
		   });
		addAnnotation
		  (getCompletionTokensDetails_RejectedPredictionTokens(),
		   source,
		   new String[] {
			   "kind", "element",
			   "name", "rejected_prediction_tokens"
		   });
	}

} //ChatCompletionPackageImpl
