/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionRequest;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Message;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ResponseFormat;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Request</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionRequestImpl#getResponseFormat <em>Response Format</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ChatCompletionRequestImpl extends MinimalEObjectImpl.Container implements ChatCompletionRequest {
	/**
	 * The default value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected String model = MODEL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> messages;

	/**
	 * The cached value of the '{@link #getResponseFormat() <em>Response Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResponseFormat()
	 * @generated
	 * @ordered
	 */
	protected ResponseFormat responseFormat;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChatCompletionRequestImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ChatCompletionPackage.Literals.CHAT_COMPLETION_REQUEST;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getModel() {
		return model;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(String newModel) {
		String oldModel = model;
		model = newModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MODEL, oldModel, model));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Message> getMessages() {
		if (messages == null) {
			messages = new EObjectContainmentEList<Message>(Message.class, this, ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES);
		}
		return messages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResponseFormat getResponseFormat() {
		return responseFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetResponseFormat(ResponseFormat newResponseFormat, NotificationChain msgs) {
		ResponseFormat oldResponseFormat = responseFormat;
		responseFormat = newResponseFormat;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT, oldResponseFormat, newResponseFormat);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setResponseFormat(ResponseFormat newResponseFormat) {
		if (newResponseFormat != responseFormat) {
			NotificationChain msgs = null;
			if (responseFormat != null)
				msgs = ((InternalEObject)responseFormat).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT, null, msgs);
			if (newResponseFormat != null)
				msgs = ((InternalEObject)newResponseFormat).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT, null, msgs);
			msgs = basicSetResponseFormat(newResponseFormat, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT, newResponseFormat, newResponseFormat));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES:
				return ((InternalEList<?>)getMessages()).basicRemove(otherEnd, msgs);
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT:
				return basicSetResponseFormat(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MODEL:
				return getModel();
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES:
				return getMessages();
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT:
				return getResponseFormat();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MODEL:
				setModel((String)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT:
				setResponseFormat((ResponseFormat)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MODEL:
				setModel(MODEL_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES:
				getMessages().clear();
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT:
				setResponseFormat((ResponseFormat)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MODEL:
				return MODEL_EDEFAULT == null ? model != null : !MODEL_EDEFAULT.equals(model);
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__MESSAGES:
				return messages != null && !messages.isEmpty();
			case ChatCompletionPackage.CHAT_COMPLETION_REQUEST__RESPONSE_FORMAT:
				return responseFormat != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (model: ");
		result.append(model);
		result.append(')');
		return result.toString();
	}

} //ChatCompletionRequestImpl
