/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionResponse;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Choice;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Response</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getObject <em>Object</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getCreated <em>Created</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getChoices <em>Choices</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getUsage <em>Usage</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getServiceTier <em>Service Tier</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.ChatCompletionResponseImpl#getSystemFingerprint <em>System Fingerprint</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ChatCompletionResponseImpl extends MinimalEObjectImpl.Container implements ChatCompletionResponse {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getObject() <em>Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObject()
	 * @generated
	 * @ordered
	 */
	protected static final String OBJECT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getObject() <em>Object</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObject()
	 * @generated
	 * @ordered
	 */
	protected String object = OBJECT_EDEFAULT;

	/**
	 * The default value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected String model = MODEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreated() <em>Created</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreated()
	 * @generated
	 * @ordered
	 */
	protected static final long CREATED_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getCreated() <em>Created</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreated()
	 * @generated
	 * @ordered
	 */
	protected long created = CREATED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getChoices() <em>Choices</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChoices()
	 * @generated
	 * @ordered
	 */
	protected EList<Choice> choices;

	/**
	 * The cached value of the '{@link #getUsage() <em>Usage</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsage()
	 * @generated
	 * @ordered
	 */
	protected Usage usage;

	/**
	 * The default value of the '{@link #getServiceTier() <em>Service Tier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceTier()
	 * @generated
	 * @ordered
	 */
	protected static final String SERVICE_TIER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getServiceTier() <em>Service Tier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceTier()
	 * @generated
	 * @ordered
	 */
	protected String serviceTier = SERVICE_TIER_EDEFAULT;

	/**
	 * The default value of the '{@link #getSystemFingerprint() <em>System Fingerprint</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSystemFingerprint()
	 * @generated
	 * @ordered
	 */
	protected static final String SYSTEM_FINGERPRINT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSystemFingerprint() <em>System Fingerprint</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSystemFingerprint()
	 * @generated
	 * @ordered
	 */
	protected String systemFingerprint = SYSTEM_FINGERPRINT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChatCompletionResponseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ChatCompletionPackage.Literals.CHAT_COMPLETION_RESPONSE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getObject() {
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setObject(String newObject) {
		String oldObject = object;
		object = newObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__OBJECT, oldObject, object));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getModel() {
		return model;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(String newModel) {
		String oldModel = model;
		model = newModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__MODEL, oldModel, model));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public long getCreated() {
		return created;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreated(long newCreated) {
		long oldCreated = created;
		created = newCreated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CREATED, oldCreated, created));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Choice> getChoices() {
		if (choices == null) {
			choices = new EObjectContainmentEList<Choice>(Choice.class, this, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES);
		}
		return choices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Usage getUsage() {
		if (usage != null && usage.eIsProxy()) {
			InternalEObject oldUsage = (InternalEObject)usage;
			usage = (Usage)eResolveProxy(oldUsage);
			if (usage != oldUsage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE, oldUsage, usage));
			}
		}
		return usage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Usage basicGetUsage() {
		return usage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUsage(Usage newUsage) {
		Usage oldUsage = usage;
		usage = newUsage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE, oldUsage, usage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getServiceTier() {
		return serviceTier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setServiceTier(String newServiceTier) {
		String oldServiceTier = serviceTier;
		serviceTier = newServiceTier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SERVICE_TIER, oldServiceTier, serviceTier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSystemFingerprint() {
		return systemFingerprint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSystemFingerprint(String newSystemFingerprint) {
		String oldSystemFingerprint = systemFingerprint;
		systemFingerprint = newSystemFingerprint;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT, oldSystemFingerprint, systemFingerprint));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES:
				return ((InternalEList<?>)getChoices()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__ID:
				return getId();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__OBJECT:
				return getObject();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__MODEL:
				return getModel();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CREATED:
				return getCreated();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES:
				return getChoices();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE:
				if (resolve) return getUsage();
				return basicGetUsage();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SERVICE_TIER:
				return getServiceTier();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT:
				return getSystemFingerprint();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__ID:
				setId((String)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__OBJECT:
				setObject((String)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__MODEL:
				setModel((String)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CREATED:
				setCreated((Long)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES:
				getChoices().clear();
				getChoices().addAll((Collection<? extends Choice>)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE:
				setUsage((Usage)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SERVICE_TIER:
				setServiceTier((String)newValue);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT:
				setSystemFingerprint((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__ID:
				setId(ID_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__OBJECT:
				setObject(OBJECT_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__MODEL:
				setModel(MODEL_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CREATED:
				setCreated(CREATED_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES:
				getChoices().clear();
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE:
				setUsage((Usage)null);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SERVICE_TIER:
				setServiceTier(SERVICE_TIER_EDEFAULT);
				return;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT:
				setSystemFingerprint(SYSTEM_FINGERPRINT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__OBJECT:
				return OBJECT_EDEFAULT == null ? object != null : !OBJECT_EDEFAULT.equals(object);
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__MODEL:
				return MODEL_EDEFAULT == null ? model != null : !MODEL_EDEFAULT.equals(model);
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CREATED:
				return created != CREATED_EDEFAULT;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__CHOICES:
				return choices != null && !choices.isEmpty();
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__USAGE:
				return usage != null;
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SERVICE_TIER:
				return SERVICE_TIER_EDEFAULT == null ? serviceTier != null : !SERVICE_TIER_EDEFAULT.equals(serviceTier);
			case ChatCompletionPackage.CHAT_COMPLETION_RESPONSE__SYSTEM_FINGERPRINT:
				return SYSTEM_FINGERPRINT_EDEFAULT == null ? systemFingerprint != null : !SYSTEM_FINGERPRINT_EDEFAULT.equals(systemFingerprint);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", object: ");
		result.append(object);
		result.append(", model: ");
		result.append(model);
		result.append(", created: ");
		result.append(created);
		result.append(", serviceTier: ");
		result.append(serviceTier);
		result.append(", systemFingerprint: ");
		result.append(systemFingerprint);
		result.append(')');
		return result.toString();
	}

} //ChatCompletionResponseImpl
