/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Completion Tokens Details</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl#getReasoningTokens <em>Reasoning Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl#getAudioTokens <em>Audio Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl#getAcceptedPredictionTokens <em>Accepted Prediction Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.CompletionTokensDetailsImpl#getRejectedPredictionTokens <em>Rejected Prediction Tokens</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CompletionTokensDetailsImpl extends MinimalEObjectImpl.Container implements CompletionTokensDetails {
	/**
	 * The default value of the '{@link #getReasoningTokens() <em>Reasoning Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReasoningTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int REASONING_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getReasoningTokens() <em>Reasoning Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReasoningTokens()
	 * @generated
	 * @ordered
	 */
	protected int reasoningTokens = REASONING_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getAudioTokens() <em>Audio Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAudioTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int AUDIO_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAudioTokens() <em>Audio Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAudioTokens()
	 * @generated
	 * @ordered
	 */
	protected int audioTokens = AUDIO_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getAcceptedPredictionTokens() <em>Accepted Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcceptedPredictionTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int ACCEPTED_PREDICTION_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAcceptedPredictionTokens() <em>Accepted Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAcceptedPredictionTokens()
	 * @generated
	 * @ordered
	 */
	protected int acceptedPredictionTokens = ACCEPTED_PREDICTION_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getRejectedPredictionTokens() <em>Rejected Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRejectedPredictionTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int REJECTED_PREDICTION_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRejectedPredictionTokens() <em>Rejected Prediction Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRejectedPredictionTokens()
	 * @generated
	 * @ordered
	 */
	protected int rejectedPredictionTokens = REJECTED_PREDICTION_TOKENS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompletionTokensDetailsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ChatCompletionPackage.Literals.COMPLETION_TOKENS_DETAILS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getReasoningTokens() {
		return reasoningTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReasoningTokens(int newReasoningTokens) {
		int oldReasoningTokens = reasoningTokens;
		reasoningTokens = newReasoningTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REASONING_TOKENS, oldReasoningTokens, reasoningTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getAudioTokens() {
		return audioTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAudioTokens(int newAudioTokens) {
		int oldAudioTokens = audioTokens;
		audioTokens = newAudioTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS, oldAudioTokens, audioTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getAcceptedPredictionTokens() {
		return acceptedPredictionTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAcceptedPredictionTokens(int newAcceptedPredictionTokens) {
		int oldAcceptedPredictionTokens = acceptedPredictionTokens;
		acceptedPredictionTokens = newAcceptedPredictionTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS, oldAcceptedPredictionTokens, acceptedPredictionTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getRejectedPredictionTokens() {
		return rejectedPredictionTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRejectedPredictionTokens(int newRejectedPredictionTokens) {
		int oldRejectedPredictionTokens = rejectedPredictionTokens;
		rejectedPredictionTokens = newRejectedPredictionTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS, oldRejectedPredictionTokens, rejectedPredictionTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REASONING_TOKENS:
				return getReasoningTokens();
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS:
				return getAudioTokens();
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS:
				return getAcceptedPredictionTokens();
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS:
				return getRejectedPredictionTokens();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REASONING_TOKENS:
				setReasoningTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS:
				setAudioTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS:
				setAcceptedPredictionTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS:
				setRejectedPredictionTokens((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REASONING_TOKENS:
				setReasoningTokens(REASONING_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS:
				setAudioTokens(AUDIO_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS:
				setAcceptedPredictionTokens(ACCEPTED_PREDICTION_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS:
				setRejectedPredictionTokens(REJECTED_PREDICTION_TOKENS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REASONING_TOKENS:
				return reasoningTokens != REASONING_TOKENS_EDEFAULT;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__AUDIO_TOKENS:
				return audioTokens != AUDIO_TOKENS_EDEFAULT;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__ACCEPTED_PREDICTION_TOKENS:
				return acceptedPredictionTokens != ACCEPTED_PREDICTION_TOKENS_EDEFAULT;
			case ChatCompletionPackage.COMPLETION_TOKENS_DETAILS__REJECTED_PREDICTION_TOKENS:
				return rejectedPredictionTokens != REJECTED_PREDICTION_TOKENS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (reasoningTokens: ");
		result.append(reasoningTokens);
		result.append(", audioTokens: ");
		result.append(audioTokens);
		result.append(", acceptedPredictionTokens: ");
		result.append(acceptedPredictionTokens);
		result.append(", rejectedPredictionTokens: ");
		result.append(rejectedPredictionTokens);
		result.append(')');
		return result.toString();
	}

} //CompletionTokensDetailsImpl
