/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.ChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.CompletionTokensDetails;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.PromptTokenDetails;
import org.eclipse.fennec.ai.chat.completion.model.chatcompletion.Usage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Usage</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl#getPromptTokens <em>Prompt Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl#getCompletionTokens <em>Completion Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl#getTotalTokens <em>Total Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl#getPromptTokenDetails <em>Prompt Token Details</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.chatcompletion.impl.UsageImpl#getCompletionTokenDetails <em>Completion Token Details</em>}</li>
 * </ul>
 *
 * @generated
 */
public class UsageImpl extends MinimalEObjectImpl.Container implements Usage {
	/**
	 * The default value of the '{@link #getPromptTokens() <em>Prompt Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int PROMPT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPromptTokens() <em>Prompt Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokens()
	 * @generated
	 * @ordered
	 */
	protected int promptTokens = PROMPT_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getCompletionTokens() <em>Completion Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCompletionTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int COMPLETION_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCompletionTokens() <em>Completion Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCompletionTokens()
	 * @generated
	 * @ordered
	 */
	protected int completionTokens = COMPLETION_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalTokens() <em>Total Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalTokens() <em>Total Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalTokens()
	 * @generated
	 * @ordered
	 */
	protected int totalTokens = TOTAL_TOKENS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPromptTokenDetails() <em>Prompt Token Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromptTokenDetails()
	 * @generated
	 * @ordered
	 */
	protected PromptTokenDetails promptTokenDetails;

	/**
	 * The cached value of the '{@link #getCompletionTokenDetails() <em>Completion Token Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCompletionTokenDetails()
	 * @generated
	 * @ordered
	 */
	protected CompletionTokensDetails completionTokenDetails;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ChatCompletionPackage.Literals.USAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPromptTokens() {
		return promptTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPromptTokens(int newPromptTokens) {
		int oldPromptTokens = promptTokens;
		promptTokens = newPromptTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__PROMPT_TOKENS, oldPromptTokens, promptTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCompletionTokens() {
		return completionTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCompletionTokens(int newCompletionTokens) {
		int oldCompletionTokens = completionTokens;
		completionTokens = newCompletionTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__COMPLETION_TOKENS, oldCompletionTokens, completionTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getTotalTokens() {
		return totalTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTotalTokens(int newTotalTokens) {
		int oldTotalTokens = totalTokens;
		totalTokens = newTotalTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__TOTAL_TOKENS, oldTotalTokens, totalTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PromptTokenDetails getPromptTokenDetails() {
		return promptTokenDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPromptTokenDetails(PromptTokenDetails newPromptTokenDetails, NotificationChain msgs) {
		PromptTokenDetails oldPromptTokenDetails = promptTokenDetails;
		promptTokenDetails = newPromptTokenDetails;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS, oldPromptTokenDetails, newPromptTokenDetails);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPromptTokenDetails(PromptTokenDetails newPromptTokenDetails) {
		if (newPromptTokenDetails != promptTokenDetails) {
			NotificationChain msgs = null;
			if (promptTokenDetails != null)
				msgs = ((InternalEObject)promptTokenDetails).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS, null, msgs);
			if (newPromptTokenDetails != null)
				msgs = ((InternalEObject)newPromptTokenDetails).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS, null, msgs);
			msgs = basicSetPromptTokenDetails(newPromptTokenDetails, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS, newPromptTokenDetails, newPromptTokenDetails));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CompletionTokensDetails getCompletionTokenDetails() {
		return completionTokenDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCompletionTokenDetails(CompletionTokensDetails newCompletionTokenDetails, NotificationChain msgs) {
		CompletionTokensDetails oldCompletionTokenDetails = completionTokenDetails;
		completionTokenDetails = newCompletionTokenDetails;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS, oldCompletionTokenDetails, newCompletionTokenDetails);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCompletionTokenDetails(CompletionTokensDetails newCompletionTokenDetails) {
		if (newCompletionTokenDetails != completionTokenDetails) {
			NotificationChain msgs = null;
			if (completionTokenDetails != null)
				msgs = ((InternalEObject)completionTokenDetails).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS, null, msgs);
			if (newCompletionTokenDetails != null)
				msgs = ((InternalEObject)newCompletionTokenDetails).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS, null, msgs);
			msgs = basicSetCompletionTokenDetails(newCompletionTokenDetails, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS, newCompletionTokenDetails, newCompletionTokenDetails));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS:
				return basicSetPromptTokenDetails(null, msgs);
			case ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS:
				return basicSetCompletionTokenDetails(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ChatCompletionPackage.USAGE__PROMPT_TOKENS:
				return getPromptTokens();
			case ChatCompletionPackage.USAGE__COMPLETION_TOKENS:
				return getCompletionTokens();
			case ChatCompletionPackage.USAGE__TOTAL_TOKENS:
				return getTotalTokens();
			case ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS:
				return getPromptTokenDetails();
			case ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS:
				return getCompletionTokenDetails();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ChatCompletionPackage.USAGE__PROMPT_TOKENS:
				setPromptTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKENS:
				setCompletionTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.USAGE__TOTAL_TOKENS:
				setTotalTokens((Integer)newValue);
				return;
			case ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS:
				setPromptTokenDetails((PromptTokenDetails)newValue);
				return;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS:
				setCompletionTokenDetails((CompletionTokensDetails)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.USAGE__PROMPT_TOKENS:
				setPromptTokens(PROMPT_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKENS:
				setCompletionTokens(COMPLETION_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.USAGE__TOTAL_TOKENS:
				setTotalTokens(TOTAL_TOKENS_EDEFAULT);
				return;
			case ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS:
				setPromptTokenDetails((PromptTokenDetails)null);
				return;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS:
				setCompletionTokenDetails((CompletionTokensDetails)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ChatCompletionPackage.USAGE__PROMPT_TOKENS:
				return promptTokens != PROMPT_TOKENS_EDEFAULT;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKENS:
				return completionTokens != COMPLETION_TOKENS_EDEFAULT;
			case ChatCompletionPackage.USAGE__TOTAL_TOKENS:
				return totalTokens != TOTAL_TOKENS_EDEFAULT;
			case ChatCompletionPackage.USAGE__PROMPT_TOKEN_DETAILS:
				return promptTokenDetails != null;
			case ChatCompletionPackage.USAGE__COMPLETION_TOKEN_DETAILS:
				return completionTokenDetails != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (promptTokens: ");
		result.append(promptTokens);
		result.append(", completionTokens: ");
		result.append(completionTokens);
		result.append(", totalTokens: ");
		result.append(totalTokens);
		result.append(')');
		return result.toString();
	}

} //UsageImpl
