/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Array Json Schema</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema#getItems <em>Items</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getArrayJsonSchema()
 * @model
 * @generated
 */
@ProviderType
public interface ArrayJsonSchema extends JsonSchema {
	/**
	 * Returns the value of the '<em><b>Items</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Items</em>' containment reference.
	 * @see #setItems(JsonSchema)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getArrayJsonSchema_Items()
	 * @model containment="true"
	 * @generated
	 */
	JsonSchema getItems();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema#getItems <em>Items</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Items</em>' containment reference.
	 * @see #getItems()
	 * @generated
	 */
	void setItems(JsonSchema value);

} // ArrayJsonSchema
