/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Artificial EClass Json Schema</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This is to allow us to serialize and deserialize stuff like anyOf and oneOf, and also array types at the level of an EPackage
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFSubSchemas <em>XEMF Sub Schemas</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFArtificialType <em>XEMF Artificial Type</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getArtificialEClassJsonSchema()
 * @model
 * @generated
 */
@ProviderType
public interface ArtificialEClassJsonSchema extends JsonSchema {
	/**
	 * Returns the value of the '<em><b>XEMF Sub Schemas</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>XEMF Sub Schemas</em>' attribute list.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getArtificialEClassJsonSchema_XEMFSubSchemas()
	 * @model annotation="JsonProperty value='x-emf-sub-schemas'"
	 * @generated
	 */
	EList<String> getXEMFSubSchemas();

	/**
	 * Returns the value of the '<em><b>XEMF Artificial Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is needed to keep track whether we are dealing with anyOf or oneOf
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>XEMF Artificial Type</em>' attribute.
	 * @see #setXEMFArtificialType(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getArtificialEClassJsonSchema_XEMFArtificialType()
	 * @model annotation="JsonProperty value='x-emf-artificial-type'"
	 * @generated
	 */
	String getXEMFArtificialType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFArtificialType <em>XEMF Artificial Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>XEMF Artificial Type</em>' attribute.
	 * @see #getXEMFArtificialType()
	 * @generated
	 */
	void setXEMFArtificialType(String value);

} // ArtificialEClassJsonSchema
