/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Enum Json Schema</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema#getEnum <em>Enum</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getEnumJsonSchema()
 * @model
 * @generated
 */
@ProviderType
public interface EnumJsonSchema extends JsonSchema {
	/**
	 * Returns the value of the '<em><b>Enum</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Enum</em>' attribute list.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getEnumJsonSchema_Enum()
	 * @model
	 * @generated
	 */
	EList<String> getEnum();

} // EnumJsonSchema
