/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Json Schema</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTitle <em>Title</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTypeList <em>Type List</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isAdditionalProperties <em>Additional Properties</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getRequired <em>Required</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFRequired <em>XEMF Required</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFContained <em>XEMF Contained</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFInstanceClassName <em>XEMF Instance Class Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFIsReference <em>XEMF Is Reference</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore/OCL OnlyOneTypeSet='(self.type.oclIsUndefined() and not self.typeList-&gt;isEmpty()) or  (not self.type.oclIsUndefined() and self.typeList-&gt;isEmpty())'"
 * @generated
 */
@ProviderType
public interface JsonSchema extends EObject {
	/**
	 * Returns the value of the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Title</em>' attribute.
	 * @see #setTitle(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Title()
	 * @model
	 * @generated
	 */
	String getTitle();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTitle <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Title</em>' attribute.
	 * @see #getTitle()
	 * @generated
	 */
	void setTitle(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Type()
	 * @model
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Type List</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is to account of schemas with multiple types. Either this property is set or the type property is set.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type List</em>' attribute list.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_TypeList()
	 * @model annotation="JsonProperty value='type'"
	 * @generated
	 */
	EList<String> getTypeList();

	/**
	 * Returns the value of the '<em><b>Properties</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Properties</em>' map.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Properties()
	 * @model mapType="org.eclipse.fennec.ai.jsonschema.model.jsonschema.Property&lt;org.eclipse.emf.ecore.EString, org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema&gt;"
	 * @generated
	 */
	EMap<String, JsonSchema> getProperties();

	/**
	 * Returns the value of the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Additional Properties</em>' attribute.
	 * @see #setAdditionalProperties(boolean)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_AdditionalProperties()
	 * @model
	 * @generated
	 */
	boolean isAdditionalProperties();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isAdditionalProperties <em>Additional Properties</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Additional Properties</em>' attribute.
	 * @see #isAdditionalProperties()
	 * @generated
	 */
	void setAdditionalProperties(boolean value);

	/**
	 * Returns the value of the '<em><b>Required</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is the list of required attributes as openAI wants it, so every attribute has to be marked as required.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Required</em>' attribute list.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Required()
	 * @model
	 * @generated
	 */
	EList<String> getRequired();

	/**
	 * Returns the value of the '<em><b>XEMF Required</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This would be the actual list of required attributes when we construct back the EPackage from jsonschema. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>XEMF Required</em>' attribute list.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_XEMFRequired()
	 * @model annotation="JsonProperty value='x-emf-required'"
	 * @generated
	 */
	EList<String> getXEMFRequired();

	/**
	 * Returns the value of the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is to mark a JsonSchema for a certain reference as contained or non contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>XEMF Contained</em>' attribute.
	 * @see #setXEMFContained(boolean)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_XEMFContained()
	 * @model annotation="JsonProperty value='x-emf-contained'"
	 * @generated
	 */
	boolean isXEMFContained();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFContained <em>XEMF Contained</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>XEMF Contained</em>' attribute.
	 * @see #isXEMFContained()
	 * @generated
	 */
	void setXEMFContained(boolean value);

	/**
	 * Returns the value of the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is to add the instance class name for EDataType
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>XEMF Instance Class Name</em>' attribute.
	 * @see #setXEMFInstanceClassName(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_XEMFInstanceClassName()
	 * @model annotation="JsonProperty value='x-emf-instance-class-name'"
	 * @generated
	 */
	String getXEMFInstanceClassName();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFInstanceClassName <em>XEMF Instance Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>XEMF Instance Class Name</em>' attribute.
	 * @see #getXEMFInstanceClassName()
	 * @generated
	 */
	void setXEMFInstanceClassName(String value);

	/**
	 * Returns the value of the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Format</em>' attribute.
	 * @see #setFormat(String)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_Format()
	 * @model
	 * @generated
	 */
	String getFormat();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getFormat <em>Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Format</em>' attribute.
	 * @see #getFormat()
	 * @generated
	 */
	void setFormat(String value);

	/**
	 * Returns the value of the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is to mark a json schema for an EMF reference
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>XEMF Is Reference</em>' attribute.
	 * @see #setXEMFIsReference(boolean)
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchema_XEMFIsReference()
	 * @model annotation="JsonProperty value='x-emf-is-reference'"
	 * @generated
	 */
	boolean isXEMFIsReference();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFIsReference <em>XEMF Is Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>XEMF Is Reference</em>' attribute.
	 * @see #isXEMFIsReference()
	 * @generated
	 */
	void setXEMFIsReference(boolean value);

} // JsonSchema
