/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Definition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition#getDefinitions <em>Definitions</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchemaDefinition()
 * @model
 * @generated
 */
@ProviderType
public interface JsonSchemaDefinition extends EObject {
	/**
	 * Returns the value of the '<em><b>Definitions</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Definitions</em>' map.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#getJsonSchemaDefinition_Definitions()
	 * @model mapType="org.eclipse.fennec.ai.jsonschema.model.jsonschema.Property&lt;org.eclipse.emf.ecore.EString, org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema&gt;"
	 * @generated
	 */
	EMap<String, JsonSchema> getDefinitions();

} // JsonSchemaDefinition
