/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage
 * @generated
 */
@ProviderType
public interface JsonSchemaFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	JsonSchemaFactory eINSTANCE = org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Json Schema</em>'.
	 * @generated
	 */
	JsonSchema createJsonSchema();

	/**
	 * Returns a new object of class '<em>Array Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Json Schema</em>'.
	 * @generated
	 */
	ArrayJsonSchema createArrayJsonSchema();

	/**
	 * Returns a new object of class '<em>Enum Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enum Json Schema</em>'.
	 * @generated
	 */
	EnumJsonSchema createEnumJsonSchema();

	/**
	 * Returns a new object of class '<em>EClass Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EClass Json Schema</em>'.
	 * @generated
	 */
	EClassJsonSchema createEClassJsonSchema();

	/**
	 * Returns a new object of class '<em>EData Type Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EData Type Json Schema</em>'.
	 * @generated
	 */
	EDataTypeJsonSchema createEDataTypeJsonSchema();

	/**
	 * Returns a new object of class '<em>Reference Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Json Schema</em>'.
	 * @generated
	 */
	ReferenceJsonSchema createReferenceJsonSchema();

	/**
	 * Returns a new object of class '<em>Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition</em>'.
	 * @generated
	 */
	JsonSchemaDefinition createJsonSchemaDefinition();

	/**
	 * Returns a new object of class '<em>Artificial EClass Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Artificial EClass Json Schema</em>'.
	 * @generated
	 */
	ArtificialEClassJsonSchema createArtificialEClassJsonSchema();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	JsonSchemaPackage getJsonSchemaPackage();

} //JsonSchemaFactory
