/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel complianceLevel='17.0' oSGiCompatible='true' basePackage='org.eclipse.fennec.ai.jsonschema.model' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motion - initial API and implementation\n'"
 * @generated
 */
@ProviderType
@EPackage(uri = JsonSchemaPackage.eNS_URI, genModel = "/model/jsonschema.genmodel", genModelSourceLocations = {"model/jsonschema.genmodel","org.eclipse.fennec.ai.jsonschema.model/model/jsonschema.genmodel"}, ecore="/model/jsonschema.ecore", ecoreSourceLocations="/model/jsonschema.ecore")
public interface JsonSchemaPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "jsonschema";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://eclipse.org/fennec/ai/jsonschema/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "jsonschema";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	JsonSchemaPackage eINSTANCE = org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl <em>Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getJsonSchema()
	 * @generated
	 */
	int JSON_SCHEMA = 0;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__TITLE = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__TYPE = 2;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__TYPE_LIST = 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__PROPERTIES = 4;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__ADDITIONAL_PROPERTIES = 5;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__REQUIRED = 6;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__XEMF_REQUIRED = 7;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__XEMF_CONTAINED = 8;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = 9;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__FORMAT = 10;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA__XEMF_IS_REFERENCE = 11;

	/**
	 * The number of structural features of the '<em>Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.PropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.PropertyImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getProperty()
	 * @generated
	 */
	int PROPERTY = 1;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArrayJsonSchemaImpl <em>Array Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArrayJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getArrayJsonSchema()
	 * @generated
	 */
	int ARRAY_JSON_SCHEMA = 2;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA__ITEMS = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Array Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Array Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EnumJsonSchemaImpl <em>Enum Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EnumJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEnumJsonSchema()
	 * @generated
	 */
	int ENUM_JSON_SCHEMA = 3;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The feature id for the '<em><b>Enum</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA__ENUM = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enum Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Enum Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EClassJsonSchemaImpl <em>EClass Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EClassJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEClassJsonSchema()
	 * @generated
	 */
	int ECLASS_JSON_SCHEMA = 4;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The number of structural features of the '<em>EClass Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>EClass Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ECLASS_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EDataTypeJsonSchemaImpl <em>EData Type Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EDataTypeJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEDataTypeJsonSchema()
	 * @generated
	 */
	int EDATA_TYPE_JSON_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The number of structural features of the '<em>EData Type Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>EData Type Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDATA_TYPE_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ReferenceJsonSchemaImpl <em>Reference Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ReferenceJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getReferenceJsonSchema()
	 * @generated
	 */
	int REFERENCE_JSON_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA__REF = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reference Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Reference Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaDefinitionImpl <em>Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaDefinitionImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getJsonSchemaDefinition()
	 * @generated
	 */
	int JSON_SCHEMA_DEFINITION = 7;

	/**
	 * The feature id for the '<em><b>Definitions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA_DEFINITION__DEFINITIONS = 0;

	/**
	 * The number of structural features of the '<em>Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA_DEFINITION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_SCHEMA_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl <em>Artificial EClass Json Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getArtificialEClassJsonSchema()
	 * @generated
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__TITLE = JSON_SCHEMA__TITLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__DESCRIPTION = JSON_SCHEMA__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__TYPE = JSON_SCHEMA__TYPE;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__TYPE_LIST = JSON_SCHEMA__TYPE_LIST;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__PROPERTIES = JSON_SCHEMA__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Additional Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__ADDITIONAL_PROPERTIES = JSON_SCHEMA__ADDITIONAL_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__REQUIRED = JSON_SCHEMA__REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Required</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_REQUIRED = JSON_SCHEMA__XEMF_REQUIRED;

	/**
	 * The feature id for the '<em><b>XEMF Contained</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_CONTAINED = JSON_SCHEMA__XEMF_CONTAINED;

	/**
	 * The feature id for the '<em><b>XEMF Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__FORMAT = JSON_SCHEMA__FORMAT;

	/**
	 * The feature id for the '<em><b>XEMF Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_IS_REFERENCE = JSON_SCHEMA__XEMF_IS_REFERENCE;

	/**
	 * The feature id for the '<em><b>XEMF Sub Schemas</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS = JSON_SCHEMA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>XEMF Artificial Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE = JSON_SCHEMA_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Artificial EClass Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA_FEATURE_COUNT = JSON_SCHEMA_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Artificial EClass Json Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARTIFICIAL_ECLASS_JSON_SCHEMA_OPERATION_COUNT = JSON_SCHEMA_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema <em>Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema
	 * @generated
	 */
	EClass getJsonSchema();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTitle()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getDescription()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getType()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_Type();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTypeList <em>Type List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Type List</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getTypeList()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_TypeList();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Properties</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getProperties()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EReference getJsonSchema_Properties();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isAdditionalProperties <em>Additional Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Additional Properties</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isAdditionalProperties()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_AdditionalProperties();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getRequired <em>Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Required</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getRequired()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_Required();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFRequired <em>XEMF Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>XEMF Required</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFRequired()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_XEMFRequired();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFContained <em>XEMF Contained</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XEMF Contained</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFContained()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_XEMFContained();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFInstanceClassName <em>XEMF Instance Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XEMF Instance Class Name</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getXEMFInstanceClassName()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_XEMFInstanceClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getFormat <em>Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Format</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#getFormat()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_Format();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFIsReference <em>XEMF Is Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XEMF Is Reference</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema#isXEMFIsReference()
	 * @see #getJsonSchema()
	 * @generated
	 */
	EAttribute getJsonSchema_XEMFIsReference();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see java.util.Map.Entry
	 * @model keyDataType="org.eclipse.emf.ecore.EString"
	 *        valueType="org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema" valueContainment="true"
	 * @generated
	 */
	EClass getProperty();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getProperty()
	 * @generated
	 */
	EAttribute getProperty_Key();

	/**
	 * Returns the meta object for the containment reference '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getProperty()
	 * @generated
	 */
	EReference getProperty_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema <em>Array Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema
	 * @generated
	 */
	EClass getArrayJsonSchema();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema#getItems <em>Items</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Items</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema#getItems()
	 * @see #getArrayJsonSchema()
	 * @generated
	 */
	EReference getArrayJsonSchema_Items();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema <em>Enum Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema
	 * @generated
	 */
	EClass getEnumJsonSchema();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema#getEnum <em>Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Enum</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema#getEnum()
	 * @see #getEnumJsonSchema()
	 * @generated
	 */
	EAttribute getEnumJsonSchema_Enum();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EClassJsonSchema <em>EClass Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EClass Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EClassJsonSchema
	 * @generated
	 */
	EClass getEClassJsonSchema();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EDataTypeJsonSchema <em>EData Type Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EData Type Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EDataTypeJsonSchema
	 * @generated
	 */
	EClass getEDataTypeJsonSchema();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema <em>Reference Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema
	 * @generated
	 */
	EClass getReferenceJsonSchema();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema#getRef <em>Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ref</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema#getRef()
	 * @see #getReferenceJsonSchema()
	 * @generated
	 */
	EAttribute getReferenceJsonSchema_Ref();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition <em>Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Definition</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition
	 * @generated
	 */
	EClass getJsonSchemaDefinition();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition#getDefinitions <em>Definitions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Definitions</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition#getDefinitions()
	 * @see #getJsonSchemaDefinition()
	 * @generated
	 */
	EReference getJsonSchemaDefinition_Definitions();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema <em>Artificial EClass Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Artificial EClass Json Schema</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema
	 * @generated
	 */
	EClass getArtificialEClassJsonSchema();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFSubSchemas <em>XEMF Sub Schemas</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>XEMF Sub Schemas</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFSubSchemas()
	 * @see #getArtificialEClassJsonSchema()
	 * @generated
	 */
	EAttribute getArtificialEClassJsonSchema_XEMFSubSchemas();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFArtificialType <em>XEMF Artificial Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>XEMF Artificial Type</em>'.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema#getXEMFArtificialType()
	 * @see #getArtificialEClassJsonSchema()
	 * @generated
	 */
	EAttribute getArtificialEClassJsonSchema_XEMFArtificialType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	JsonSchemaFactory getJsonSchemaFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl <em>Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getJsonSchema()
		 * @generated
		 */
		EClass JSON_SCHEMA = eINSTANCE.getJsonSchema();

		/**
		 * The meta object literal for the '<em><b>Title</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__TITLE = eINSTANCE.getJsonSchema_Title();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__DESCRIPTION = eINSTANCE.getJsonSchema_Description();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__TYPE = eINSTANCE.getJsonSchema_Type();

		/**
		 * The meta object literal for the '<em><b>Type List</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__TYPE_LIST = eINSTANCE.getJsonSchema_TypeList();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JSON_SCHEMA__PROPERTIES = eINSTANCE.getJsonSchema_Properties();

		/**
		 * The meta object literal for the '<em><b>Additional Properties</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__ADDITIONAL_PROPERTIES = eINSTANCE.getJsonSchema_AdditionalProperties();

		/**
		 * The meta object literal for the '<em><b>Required</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__REQUIRED = eINSTANCE.getJsonSchema_Required();

		/**
		 * The meta object literal for the '<em><b>XEMF Required</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__XEMF_REQUIRED = eINSTANCE.getJsonSchema_XEMFRequired();

		/**
		 * The meta object literal for the '<em><b>XEMF Contained</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__XEMF_CONTAINED = eINSTANCE.getJsonSchema_XEMFContained();

		/**
		 * The meta object literal for the '<em><b>XEMF Instance Class Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME = eINSTANCE.getJsonSchema_XEMFInstanceClassName();

		/**
		 * The meta object literal for the '<em><b>Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__FORMAT = eINSTANCE.getJsonSchema_Format();

		/**
		 * The meta object literal for the '<em><b>XEMF Is Reference</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JSON_SCHEMA__XEMF_IS_REFERENCE = eINSTANCE.getJsonSchema_XEMFIsReference();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.PropertyImpl <em>Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.PropertyImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getProperty()
		 * @generated
		 */
		EClass PROPERTY = eINSTANCE.getProperty();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY__KEY = eINSTANCE.getProperty_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY__VALUE = eINSTANCE.getProperty_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArrayJsonSchemaImpl <em>Array Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArrayJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getArrayJsonSchema()
		 * @generated
		 */
		EClass ARRAY_JSON_SCHEMA = eINSTANCE.getArrayJsonSchema();

		/**
		 * The meta object literal for the '<em><b>Items</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ARRAY_JSON_SCHEMA__ITEMS = eINSTANCE.getArrayJsonSchema_Items();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EnumJsonSchemaImpl <em>Enum Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EnumJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEnumJsonSchema()
		 * @generated
		 */
		EClass ENUM_JSON_SCHEMA = eINSTANCE.getEnumJsonSchema();

		/**
		 * The meta object literal for the '<em><b>Enum</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENUM_JSON_SCHEMA__ENUM = eINSTANCE.getEnumJsonSchema_Enum();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EClassJsonSchemaImpl <em>EClass Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EClassJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEClassJsonSchema()
		 * @generated
		 */
		EClass ECLASS_JSON_SCHEMA = eINSTANCE.getEClassJsonSchema();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EDataTypeJsonSchemaImpl <em>EData Type Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.EDataTypeJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getEDataTypeJsonSchema()
		 * @generated
		 */
		EClass EDATA_TYPE_JSON_SCHEMA = eINSTANCE.getEDataTypeJsonSchema();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ReferenceJsonSchemaImpl <em>Reference Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ReferenceJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getReferenceJsonSchema()
		 * @generated
		 */
		EClass REFERENCE_JSON_SCHEMA = eINSTANCE.getReferenceJsonSchema();

		/**
		 * The meta object literal for the '<em><b>Ref</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REFERENCE_JSON_SCHEMA__REF = eINSTANCE.getReferenceJsonSchema_Ref();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaDefinitionImpl <em>Definition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaDefinitionImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getJsonSchemaDefinition()
		 * @generated
		 */
		EClass JSON_SCHEMA_DEFINITION = eINSTANCE.getJsonSchemaDefinition();

		/**
		 * The meta object literal for the '<em><b>Definitions</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JSON_SCHEMA_DEFINITION__DEFINITIONS = eINSTANCE.getJsonSchemaDefinition_Definitions();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl <em>Artificial EClass Json Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl
		 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaPackageImpl#getArtificialEClassJsonSchema()
		 * @generated
		 */
		EClass ARTIFICIAL_ECLASS_JSON_SCHEMA = eINSTANCE.getArtificialEClassJsonSchema();

		/**
		 * The meta object literal for the '<em><b>XEMF Sub Schemas</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS = eINSTANCE.getArtificialEClassJsonSchema_XEMFSubSchemas();

		/**
		 * The meta object literal for the '<em><b>XEMF Artificial Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE = eINSTANCE.getArtificialEClassJsonSchema_XEMFArtificialType();

	}

} //JsonSchemaPackage
