/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Artificial EClass Json Schema</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl#getXEMFSubSchemas <em>XEMF Sub Schemas</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.ArtificialEClassJsonSchemaImpl#getXEMFArtificialType <em>XEMF Artificial Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ArtificialEClassJsonSchemaImpl extends JsonSchemaImpl implements ArtificialEClassJsonSchema {
	/**
	 * The cached value of the '{@link #getXEMFSubSchemas() <em>XEMF Sub Schemas</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFSubSchemas()
	 * @generated
	 * @ordered
	 */
	protected EList<String> xEMFSubSchemas;

	/**
	 * The default value of the '{@link #getXEMFArtificialType() <em>XEMF Artificial Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFArtificialType()
	 * @generated
	 * @ordered
	 */
	protected static final String XEMF_ARTIFICIAL_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getXEMFArtificialType() <em>XEMF Artificial Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFArtificialType()
	 * @generated
	 * @ordered
	 */
	protected String xEMFArtificialType = XEMF_ARTIFICIAL_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArtificialEClassJsonSchemaImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return JsonSchemaPackage.Literals.ARTIFICIAL_ECLASS_JSON_SCHEMA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getXEMFSubSchemas() {
		if (xEMFSubSchemas == null) {
			xEMFSubSchemas = new EDataTypeUniqueEList<String>(String.class, this, JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS);
		}
		return xEMFSubSchemas;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getXEMFArtificialType() {
		return xEMFArtificialType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setXEMFArtificialType(String newXEMFArtificialType) {
		String oldXEMFArtificialType = xEMFArtificialType;
		xEMFArtificialType = newXEMFArtificialType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE, oldXEMFArtificialType, xEMFArtificialType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS:
				return getXEMFSubSchemas();
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE:
				return getXEMFArtificialType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS:
				getXEMFSubSchemas().clear();
				getXEMFSubSchemas().addAll((Collection<? extends String>)newValue);
				return;
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE:
				setXEMFArtificialType((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS:
				getXEMFSubSchemas().clear();
				return;
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE:
				setXEMFArtificialType(XEMF_ARTIFICIAL_TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS:
				return xEMFSubSchemas != null && !xEMFSubSchemas.isEmpty();
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE:
				return XEMF_ARTIFICIAL_TYPE_EDEFAULT == null ? xEMFArtificialType != null : !XEMF_ARTIFICIAL_TYPE_EDEFAULT.equals(xEMFArtificialType);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (xEMFSubSchemas: ");
		result.append(xEMFSubSchemas);
		result.append(", xEMFArtificialType: ");
		result.append(xEMFArtificialType);
		result.append(')');
		return result.toString();
	}

} //ArtificialEClassJsonSchemaImpl
