/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl;

import java.util.Map;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class JsonSchemaFactoryImpl extends EFactoryImpl implements JsonSchemaFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static JsonSchemaFactory init() {
		try {
			JsonSchemaFactory theJsonSchemaFactory = (JsonSchemaFactory)EPackage.Registry.INSTANCE.getEFactory(JsonSchemaPackage.eNS_URI);
			if (theJsonSchemaFactory != null) {
				return theJsonSchemaFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new JsonSchemaFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JsonSchemaFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case JsonSchemaPackage.JSON_SCHEMA: return createJsonSchema();
			case JsonSchemaPackage.PROPERTY: return (EObject)createProperty();
			case JsonSchemaPackage.ARRAY_JSON_SCHEMA: return createArrayJsonSchema();
			case JsonSchemaPackage.ENUM_JSON_SCHEMA: return createEnumJsonSchema();
			case JsonSchemaPackage.ECLASS_JSON_SCHEMA: return createEClassJsonSchema();
			case JsonSchemaPackage.EDATA_TYPE_JSON_SCHEMA: return createEDataTypeJsonSchema();
			case JsonSchemaPackage.REFERENCE_JSON_SCHEMA: return createReferenceJsonSchema();
			case JsonSchemaPackage.JSON_SCHEMA_DEFINITION: return createJsonSchemaDefinition();
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA: return createArtificialEClassJsonSchema();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JsonSchema createJsonSchema() {
		JsonSchemaImpl jsonSchema = new JsonSchemaImpl();
		return jsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry<String, JsonSchema> createProperty() {
		PropertyImpl property = new PropertyImpl();
		return property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ArrayJsonSchema createArrayJsonSchema() {
		ArrayJsonSchemaImpl arrayJsonSchema = new ArrayJsonSchemaImpl();
		return arrayJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EnumJsonSchema createEnumJsonSchema() {
		EnumJsonSchemaImpl enumJsonSchema = new EnumJsonSchemaImpl();
		return enumJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClassJsonSchema createEClassJsonSchema() {
		EClassJsonSchemaImpl eClassJsonSchema = new EClassJsonSchemaImpl();
		return eClassJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataTypeJsonSchema createEDataTypeJsonSchema() {
		EDataTypeJsonSchemaImpl eDataTypeJsonSchema = new EDataTypeJsonSchemaImpl();
		return eDataTypeJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ReferenceJsonSchema createReferenceJsonSchema() {
		ReferenceJsonSchemaImpl referenceJsonSchema = new ReferenceJsonSchemaImpl();
		return referenceJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JsonSchemaDefinition createJsonSchemaDefinition() {
		JsonSchemaDefinitionImpl jsonSchemaDefinition = new JsonSchemaDefinitionImpl();
		return jsonSchemaDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ArtificialEClassJsonSchema createArtificialEClassJsonSchema() {
		ArtificialEClassJsonSchemaImpl artificialEClassJsonSchema = new ArtificialEClassJsonSchemaImpl();
		return artificialEClassJsonSchema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JsonSchemaPackage getJsonSchemaPackage() {
		return (JsonSchemaPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static JsonSchemaPackage getPackage() {
		return JsonSchemaPackage.eINSTANCE;
	}

} //JsonSchemaFactoryImpl
