/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Json Schema</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getTypeList <em>Type List</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#isAdditionalProperties <em>Additional Properties</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getRequired <em>Required</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getXEMFRequired <em>XEMF Required</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#isXEMFContained <em>XEMF Contained</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getXEMFInstanceClassName <em>XEMF Instance Class Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl.JsonSchemaImpl#isXEMFIsReference <em>XEMF Is Reference</em>}</li>
 * </ul>
 *
 * @generated
 */
public class JsonSchemaImpl extends MinimalEObjectImpl.Container implements JsonSchema {
	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected String title = TITLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTypeList() <em>Type List</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeList()
	 * @generated
	 * @ordered
	 */
	protected EList<String> typeList;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, JsonSchema> properties;

	/**
	 * The default value of the '{@link #isAdditionalProperties() <em>Additional Properties</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAdditionalProperties()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ADDITIONAL_PROPERTIES_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAdditionalProperties() <em>Additional Properties</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAdditionalProperties()
	 * @generated
	 * @ordered
	 */
	protected boolean additionalProperties = ADDITIONAL_PROPERTIES_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRequired() <em>Required</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequired()
	 * @generated
	 * @ordered
	 */
	protected EList<String> required;

	/**
	 * The cached value of the '{@link #getXEMFRequired() <em>XEMF Required</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFRequired()
	 * @generated
	 * @ordered
	 */
	protected EList<String> xEMFRequired;

	/**
	 * The default value of the '{@link #isXEMFContained() <em>XEMF Contained</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isXEMFContained()
	 * @generated
	 * @ordered
	 */
	protected static final boolean XEMF_CONTAINED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isXEMFContained() <em>XEMF Contained</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isXEMFContained()
	 * @generated
	 * @ordered
	 */
	protected boolean xEMFContained = XEMF_CONTAINED_EDEFAULT;

	/**
	 * The default value of the '{@link #getXEMFInstanceClassName() <em>XEMF Instance Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFInstanceClassName()
	 * @generated
	 * @ordered
	 */
	protected static final String XEMF_INSTANCE_CLASS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getXEMFInstanceClassName() <em>XEMF Instance Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXEMFInstanceClassName()
	 * @generated
	 * @ordered
	 */
	protected String xEMFInstanceClassName = XEMF_INSTANCE_CLASS_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getFormat() <em>Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormat()
	 * @generated
	 * @ordered
	 */
	protected static final String FORMAT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFormat() <em>Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormat()
	 * @generated
	 * @ordered
	 */
	protected String format = FORMAT_EDEFAULT;

	/**
	 * The default value of the '{@link #isXEMFIsReference() <em>XEMF Is Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isXEMFIsReference()
	 * @generated
	 * @ordered
	 */
	protected static final boolean XEMF_IS_REFERENCE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isXEMFIsReference() <em>XEMF Is Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isXEMFIsReference()
	 * @generated
	 * @ordered
	 */
	protected boolean xEMFIsReference = XEMF_IS_REFERENCE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JsonSchemaImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return JsonSchemaPackage.Literals.JSON_SCHEMA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTitle() {
		return title;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTitle(String newTitle) {
		String oldTitle = title;
		title = newTitle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__TITLE, oldTitle, title));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getTypeList() {
		if (typeList == null) {
			typeList = new EDataTypeUniqueEList<String>(String.class, this, JsonSchemaPackage.JSON_SCHEMA__TYPE_LIST);
		}
		return typeList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, JsonSchema> getProperties() {
		if (properties == null) {
			properties = new EcoreEMap<String,JsonSchema>(JsonSchemaPackage.Literals.PROPERTY, PropertyImpl.class, this, JsonSchemaPackage.JSON_SCHEMA__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAdditionalProperties() {
		return additionalProperties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAdditionalProperties(boolean newAdditionalProperties) {
		boolean oldAdditionalProperties = additionalProperties;
		additionalProperties = newAdditionalProperties;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__ADDITIONAL_PROPERTIES, oldAdditionalProperties, additionalProperties));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getRequired() {
		if (required == null) {
			required = new EDataTypeUniqueEList<String>(String.class, this, JsonSchemaPackage.JSON_SCHEMA__REQUIRED);
		}
		return required;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getXEMFRequired() {
		if (xEMFRequired == null) {
			xEMFRequired = new EDataTypeUniqueEList<String>(String.class, this, JsonSchemaPackage.JSON_SCHEMA__XEMF_REQUIRED);
		}
		return xEMFRequired;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isXEMFContained() {
		return xEMFContained;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setXEMFContained(boolean newXEMFContained) {
		boolean oldXEMFContained = xEMFContained;
		xEMFContained = newXEMFContained;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__XEMF_CONTAINED, oldXEMFContained, xEMFContained));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getXEMFInstanceClassName() {
		return xEMFInstanceClassName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setXEMFInstanceClassName(String newXEMFInstanceClassName) {
		String oldXEMFInstanceClassName = xEMFInstanceClassName;
		xEMFInstanceClassName = newXEMFInstanceClassName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME, oldXEMFInstanceClassName, xEMFInstanceClassName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getFormat() {
		return format;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFormat(String newFormat) {
		String oldFormat = format;
		format = newFormat;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__FORMAT, oldFormat, format));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isXEMFIsReference() {
		return xEMFIsReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setXEMFIsReference(boolean newXEMFIsReference) {
		boolean oldXEMFIsReference = xEMFIsReference;
		xEMFIsReference = newXEMFIsReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, JsonSchemaPackage.JSON_SCHEMA__XEMF_IS_REFERENCE, oldXEMFIsReference, xEMFIsReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case JsonSchemaPackage.JSON_SCHEMA__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case JsonSchemaPackage.JSON_SCHEMA__TITLE:
				return getTitle();
			case JsonSchemaPackage.JSON_SCHEMA__DESCRIPTION:
				return getDescription();
			case JsonSchemaPackage.JSON_SCHEMA__TYPE:
				return getType();
			case JsonSchemaPackage.JSON_SCHEMA__TYPE_LIST:
				return getTypeList();
			case JsonSchemaPackage.JSON_SCHEMA__PROPERTIES:
				if (coreType) return getProperties();
				else return getProperties().map();
			case JsonSchemaPackage.JSON_SCHEMA__ADDITIONAL_PROPERTIES:
				return isAdditionalProperties();
			case JsonSchemaPackage.JSON_SCHEMA__REQUIRED:
				return getRequired();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_REQUIRED:
				return getXEMFRequired();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_CONTAINED:
				return isXEMFContained();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME:
				return getXEMFInstanceClassName();
			case JsonSchemaPackage.JSON_SCHEMA__FORMAT:
				return getFormat();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_IS_REFERENCE:
				return isXEMFIsReference();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case JsonSchemaPackage.JSON_SCHEMA__TITLE:
				setTitle((String)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__TYPE:
				setType((String)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__TYPE_LIST:
				getTypeList().clear();
				getTypeList().addAll((Collection<? extends String>)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__PROPERTIES:
				((EStructuralFeature.Setting)getProperties()).set(newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__ADDITIONAL_PROPERTIES:
				setAdditionalProperties((Boolean)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__REQUIRED:
				getRequired().clear();
				getRequired().addAll((Collection<? extends String>)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_REQUIRED:
				getXEMFRequired().clear();
				getXEMFRequired().addAll((Collection<? extends String>)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_CONTAINED:
				setXEMFContained((Boolean)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME:
				setXEMFInstanceClassName((String)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__FORMAT:
				setFormat((String)newValue);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_IS_REFERENCE:
				setXEMFIsReference((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case JsonSchemaPackage.JSON_SCHEMA__TITLE:
				setTitle(TITLE_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__TYPE_LIST:
				getTypeList().clear();
				return;
			case JsonSchemaPackage.JSON_SCHEMA__PROPERTIES:
				getProperties().clear();
				return;
			case JsonSchemaPackage.JSON_SCHEMA__ADDITIONAL_PROPERTIES:
				setAdditionalProperties(ADDITIONAL_PROPERTIES_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__REQUIRED:
				getRequired().clear();
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_REQUIRED:
				getXEMFRequired().clear();
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_CONTAINED:
				setXEMFContained(XEMF_CONTAINED_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME:
				setXEMFInstanceClassName(XEMF_INSTANCE_CLASS_NAME_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__FORMAT:
				setFormat(FORMAT_EDEFAULT);
				return;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_IS_REFERENCE:
				setXEMFIsReference(XEMF_IS_REFERENCE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case JsonSchemaPackage.JSON_SCHEMA__TITLE:
				return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
			case JsonSchemaPackage.JSON_SCHEMA__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case JsonSchemaPackage.JSON_SCHEMA__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case JsonSchemaPackage.JSON_SCHEMA__TYPE_LIST:
				return typeList != null && !typeList.isEmpty();
			case JsonSchemaPackage.JSON_SCHEMA__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case JsonSchemaPackage.JSON_SCHEMA__ADDITIONAL_PROPERTIES:
				return additionalProperties != ADDITIONAL_PROPERTIES_EDEFAULT;
			case JsonSchemaPackage.JSON_SCHEMA__REQUIRED:
				return required != null && !required.isEmpty();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_REQUIRED:
				return xEMFRequired != null && !xEMFRequired.isEmpty();
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_CONTAINED:
				return xEMFContained != XEMF_CONTAINED_EDEFAULT;
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME:
				return XEMF_INSTANCE_CLASS_NAME_EDEFAULT == null ? xEMFInstanceClassName != null : !XEMF_INSTANCE_CLASS_NAME_EDEFAULT.equals(xEMFInstanceClassName);
			case JsonSchemaPackage.JSON_SCHEMA__FORMAT:
				return FORMAT_EDEFAULT == null ? format != null : !FORMAT_EDEFAULT.equals(format);
			case JsonSchemaPackage.JSON_SCHEMA__XEMF_IS_REFERENCE:
				return xEMFIsReference != XEMF_IS_REFERENCE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (title: ");
		result.append(title);
		result.append(", description: ");
		result.append(description);
		result.append(", type: ");
		result.append(type);
		result.append(", typeList: ");
		result.append(typeList);
		result.append(", additionalProperties: ");
		result.append(additionalProperties);
		result.append(", required: ");
		result.append(required);
		result.append(", xEMFRequired: ");
		result.append(xEMFRequired);
		result.append(", xEMFContained: ");
		result.append(xEMFContained);
		result.append(", xEMFInstanceClassName: ");
		result.append(xEMFInstanceClassName);
		result.append(", format: ");
		result.append(format);
		result.append(", xEMFIsReference: ");
		result.append(xEMFIsReference);
		result.append(')');
		return result.toString();
	}

} //JsonSchemaImpl
