/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.impl;

import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.EClassJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.EDataTypeJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaFactory;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage;
import org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class JsonSchemaPackageImpl extends EPackageImpl implements JsonSchemaPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass jsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass propertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayJsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass enumJsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass eClassJsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass eDataTypeJsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceJsonSchemaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass jsonSchemaDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass artificialEClassJsonSchemaEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private JsonSchemaPackageImpl() {
		super(eNS_URI, JsonSchemaFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link JsonSchemaPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static JsonSchemaPackage init() {
		if (isInited) return (JsonSchemaPackage)EPackage.Registry.INSTANCE.getEPackage(JsonSchemaPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredJsonSchemaPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		JsonSchemaPackageImpl theJsonSchemaPackage = registeredJsonSchemaPackage instanceof JsonSchemaPackageImpl ? (JsonSchemaPackageImpl)registeredJsonSchemaPackage : new JsonSchemaPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theJsonSchemaPackage.createPackageContents();

		// Initialize created meta-data
		theJsonSchemaPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theJsonSchemaPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(JsonSchemaPackage.eNS_URI, theJsonSchemaPackage);
		return theJsonSchemaPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJsonSchema() {
		return jsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_Title() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_Description() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_Type() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_TypeList() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getJsonSchema_Properties() {
		return (EReference)jsonSchemaEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_AdditionalProperties() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_Required() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_XEMFRequired() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_XEMFContained() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_XEMFInstanceClassName() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_Format() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJsonSchema_XEMFIsReference() {
		return (EAttribute)jsonSchemaEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProperty() {
		return propertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getProperty_Key() {
		return (EAttribute)propertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getProperty_Value() {
		return (EReference)propertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getArrayJsonSchema() {
		return arrayJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getArrayJsonSchema_Items() {
		return (EReference)arrayJsonSchemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEnumJsonSchema() {
		return enumJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEnumJsonSchema_Enum() {
		return (EAttribute)enumJsonSchemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEClassJsonSchema() {
		return eClassJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEDataTypeJsonSchema() {
		return eDataTypeJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getReferenceJsonSchema() {
		return referenceJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getReferenceJsonSchema_Ref() {
		return (EAttribute)referenceJsonSchemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJsonSchemaDefinition() {
		return jsonSchemaDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getJsonSchemaDefinition_Definitions() {
		return (EReference)jsonSchemaDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getArtificialEClassJsonSchema() {
		return artificialEClassJsonSchemaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getArtificialEClassJsonSchema_XEMFSubSchemas() {
		return (EAttribute)artificialEClassJsonSchemaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getArtificialEClassJsonSchema_XEMFArtificialType() {
		return (EAttribute)artificialEClassJsonSchemaEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JsonSchemaFactory getJsonSchemaFactory() {
		return (JsonSchemaFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		jsonSchemaEClass = createEClass(JSON_SCHEMA);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__TITLE);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__DESCRIPTION);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__TYPE);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__TYPE_LIST);
		createEReference(jsonSchemaEClass, JSON_SCHEMA__PROPERTIES);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__ADDITIONAL_PROPERTIES);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__REQUIRED);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__XEMF_REQUIRED);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__XEMF_CONTAINED);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__XEMF_INSTANCE_CLASS_NAME);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__FORMAT);
		createEAttribute(jsonSchemaEClass, JSON_SCHEMA__XEMF_IS_REFERENCE);

		propertyEClass = createEClass(PROPERTY);
		createEAttribute(propertyEClass, PROPERTY__KEY);
		createEReference(propertyEClass, PROPERTY__VALUE);

		arrayJsonSchemaEClass = createEClass(ARRAY_JSON_SCHEMA);
		createEReference(arrayJsonSchemaEClass, ARRAY_JSON_SCHEMA__ITEMS);

		enumJsonSchemaEClass = createEClass(ENUM_JSON_SCHEMA);
		createEAttribute(enumJsonSchemaEClass, ENUM_JSON_SCHEMA__ENUM);

		eClassJsonSchemaEClass = createEClass(ECLASS_JSON_SCHEMA);

		eDataTypeJsonSchemaEClass = createEClass(EDATA_TYPE_JSON_SCHEMA);

		referenceJsonSchemaEClass = createEClass(REFERENCE_JSON_SCHEMA);
		createEAttribute(referenceJsonSchemaEClass, REFERENCE_JSON_SCHEMA__REF);

		jsonSchemaDefinitionEClass = createEClass(JSON_SCHEMA_DEFINITION);
		createEReference(jsonSchemaDefinitionEClass, JSON_SCHEMA_DEFINITION__DEFINITIONS);

		artificialEClassJsonSchemaEClass = createEClass(ARTIFICIAL_ECLASS_JSON_SCHEMA);
		createEAttribute(artificialEClassJsonSchemaEClass, ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_SUB_SCHEMAS);
		createEAttribute(artificialEClassJsonSchemaEClass, ARTIFICIAL_ECLASS_JSON_SCHEMA__XEMF_ARTIFICIAL_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		arrayJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());
		enumJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());
		eClassJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());
		eDataTypeJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());
		referenceJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());
		artificialEClassJsonSchemaEClass.getESuperTypes().add(this.getJsonSchema());

		// Initialize classes, features, and operations; add parameters
		initEClass(jsonSchemaEClass, JsonSchema.class, "JsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getJsonSchema_Title(), ecorePackage.getEString(), "title", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_Description(), ecorePackage.getEString(), "description", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_Type(), ecorePackage.getEString(), "type", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_TypeList(), ecorePackage.getEString(), "typeList", null, 0, -1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getJsonSchema_Properties(), this.getProperty(), null, "properties", null, 0, -1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_AdditionalProperties(), ecorePackage.getEBoolean(), "additionalProperties", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_Required(), ecorePackage.getEString(), "required", null, 0, -1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_XEMFRequired(), ecorePackage.getEString(), "xEMFRequired", null, 0, -1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_XEMFContained(), ecorePackage.getEBoolean(), "xEMFContained", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_XEMFInstanceClassName(), ecorePackage.getEString(), "xEMFInstanceClassName", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_Format(), ecorePackage.getEString(), "format", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getJsonSchema_XEMFIsReference(), ecorePackage.getEBoolean(), "xEMFIsReference", null, 0, 1, JsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(propertyEClass, Map.Entry.class, "Property", !IS_ABSTRACT, !IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProperty_Key(), ecorePackage.getEString(), "key", null, 0, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProperty_Value(), this.getJsonSchema(), null, "value", null, 0, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(arrayJsonSchemaEClass, ArrayJsonSchema.class, "ArrayJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayJsonSchema_Items(), this.getJsonSchema(), null, "items", null, 0, 1, ArrayJsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(enumJsonSchemaEClass, EnumJsonSchema.class, "EnumJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEnumJsonSchema_Enum(), ecorePackage.getEString(), "enum", null, 0, -1, EnumJsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(eClassJsonSchemaEClass, EClassJsonSchema.class, "EClassJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(eDataTypeJsonSchemaEClass, EDataTypeJsonSchema.class, "EDataTypeJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(referenceJsonSchemaEClass, ReferenceJsonSchema.class, "ReferenceJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getReferenceJsonSchema_Ref(), ecorePackage.getEString(), "ref", null, 0, 1, ReferenceJsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(jsonSchemaDefinitionEClass, JsonSchemaDefinition.class, "JsonSchemaDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getJsonSchemaDefinition_Definitions(), this.getProperty(), null, "definitions", null, 0, -1, JsonSchemaDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(artificialEClassJsonSchemaEClass, ArtificialEClassJsonSchema.class, "ArtificialEClassJsonSchema", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getArtificialEClassJsonSchema_XEMFSubSchemas(), ecorePackage.getEString(), "xEMFSubSchemas", null, 0, -1, ArtificialEClassJsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getArtificialEClassJsonSchema_XEMFArtificialType(), ecorePackage.getEString(), "xEMFArtificialType", null, 0, 1, ArtificialEClassJsonSchema.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// http://www.eclipse.org/emf/2002/Ecore/OCL
		createOCLAnnotations();
		// JsonProperty
		createJsonPropertyAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "complianceLevel", "17.0",
			   "oSGiCompatible", "true",
			   "basePackage", "org.eclipse.fennec.ai.jsonschema.model",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motion - initial API and implementation\n"
		   });
		addAnnotation
		  (getJsonSchema_TypeList(),
		   source,
		   new String[] {
			   "documentation", "This is to account of schemas with multiple types. Either this property is set or the type property is set."
		   });
		addAnnotation
		  (getJsonSchema_Required(),
		   source,
		   new String[] {
			   "documentation", "This is the list of required attributes as openAI wants it, so every attribute has to be marked as required."
		   });
		addAnnotation
		  (getJsonSchema_XEMFRequired(),
		   source,
		   new String[] {
			   "documentation", "This would be the actual list of required attributes when we construct back the EPackage from jsonschema. "
		   });
		addAnnotation
		  (getJsonSchema_XEMFContained(),
		   source,
		   new String[] {
			   "documentation", "This is to mark a JsonSchema for a certain reference as contained or non contained."
		   });
		addAnnotation
		  (getJsonSchema_XEMFInstanceClassName(),
		   source,
		   new String[] {
			   "documentation", "This is to add the instance class name for EDataType"
		   });
		addAnnotation
		  (getJsonSchema_XEMFIsReference(),
		   source,
		   new String[] {
			   "documentation", "This is to mark a json schema for an EMF reference"
		   });
		addAnnotation
		  (artificialEClassJsonSchemaEClass,
		   source,
		   new String[] {
			   "documentation", "This is to allow us to serialize and deserialize stuff like anyOf and oneOf, and also array types at the level of an EPackage"
		   });
		addAnnotation
		  (getArtificialEClassJsonSchema_XEMFArtificialType(),
		   source,
		   new String[] {
			   "documentation", "This is needed to keep track whether we are dealing with anyOf or oneOf"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore/OCL</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createOCLAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/Ecore/OCL";
		addAnnotation
		  (jsonSchemaEClass,
		   source,
		   new String[] {
			   "OnlyOneTypeSet", "(self.type.oclIsUndefined() and not self.typeList->isEmpty()) or  (not self.type.oclIsUndefined() and self.typeList->isEmpty())"
		   });
	}

	/**
	 * Initializes the annotations for <b>JsonProperty</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createJsonPropertyAnnotations() {
		String source = "JsonProperty";
		addAnnotation
		  (getJsonSchema_TypeList(),
		   source,
		   new String[] {
			   "value", "type"
		   });
		addAnnotation
		  (getJsonSchema_XEMFRequired(),
		   source,
		   new String[] {
			   "value", "x-emf-required"
		   });
		addAnnotation
		  (getJsonSchema_XEMFContained(),
		   source,
		   new String[] {
			   "value", "x-emf-contained"
		   });
		addAnnotation
		  (getJsonSchema_XEMFInstanceClassName(),
		   source,
		   new String[] {
			   "value", "x-emf-instance-class-name"
		   });
		addAnnotation
		  (getJsonSchema_XEMFIsReference(),
		   source,
		   new String[] {
			   "value", "x-emf-is-reference"
		   });
		addAnnotation
		  (getReferenceJsonSchema_Ref(),
		   source,
		   new String[] {
			   "value", "$ref"
		   });
		addAnnotation
		  (getArtificialEClassJsonSchema_XEMFSubSchemas(),
		   source,
		   new String[] {
			   "value", "x-emf-sub-schemas"
		   });
		addAnnotation
		  (getArtificialEClassJsonSchema_XEMFArtificialType(),
		   source,
		   new String[] {
			   "value", "x-emf-artificial-type"
		   });
	}

} //JsonSchemaPackageImpl
