/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.util;

import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage
 * @generated
 */
public class JsonSchemaAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static JsonSchemaPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JsonSchemaAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = JsonSchemaPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JsonSchemaSwitch<Adapter> modelSwitch =
		new JsonSchemaSwitch<Adapter>() {
			@Override
			public Adapter caseJsonSchema(JsonSchema object) {
				return createJsonSchemaAdapter();
			}
			@Override
			public Adapter caseProperty(Map.Entry<String, JsonSchema> object) {
				return createPropertyAdapter();
			}
			@Override
			public Adapter caseArrayJsonSchema(ArrayJsonSchema object) {
				return createArrayJsonSchemaAdapter();
			}
			@Override
			public Adapter caseEnumJsonSchema(EnumJsonSchema object) {
				return createEnumJsonSchemaAdapter();
			}
			@Override
			public Adapter caseEClassJsonSchema(EClassJsonSchema object) {
				return createEClassJsonSchemaAdapter();
			}
			@Override
			public Adapter caseEDataTypeJsonSchema(EDataTypeJsonSchema object) {
				return createEDataTypeJsonSchemaAdapter();
			}
			@Override
			public Adapter caseReferenceJsonSchema(ReferenceJsonSchema object) {
				return createReferenceJsonSchemaAdapter();
			}
			@Override
			public Adapter caseJsonSchemaDefinition(JsonSchemaDefinition object) {
				return createJsonSchemaDefinitionAdapter();
			}
			@Override
			public Adapter caseArtificialEClassJsonSchema(ArtificialEClassJsonSchema object) {
				return createArtificialEClassJsonSchemaAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema <em>Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchema
	 * @generated
	 */
	public Adapter createJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema <em>Array Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArrayJsonSchema
	 * @generated
	 */
	public Adapter createArrayJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema <em>Enum Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EnumJsonSchema
	 * @generated
	 */
	public Adapter createEnumJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EClassJsonSchema <em>EClass Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EClassJsonSchema
	 * @generated
	 */
	public Adapter createEClassJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.EDataTypeJsonSchema <em>EData Type Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.EDataTypeJsonSchema
	 * @generated
	 */
	public Adapter createEDataTypeJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema <em>Reference Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ReferenceJsonSchema
	 * @generated
	 */
	public Adapter createReferenceJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition <em>Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaDefinition
	 * @generated
	 */
	public Adapter createJsonSchemaDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema <em>Artificial EClass Json Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.ArtificialEClassJsonSchema
	 * @generated
	 */
	public Adapter createArtificialEClassJsonSchemaAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //JsonSchemaAdapterFactory
