/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 * 
 */
package org.eclipse.fennec.ai.jsonschema.model.jsonschema.util;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.fennec.ai.jsonschema.model.jsonschema.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.jsonschema.model.jsonschema.JsonSchemaPackage
 * @generated
 */
public class JsonSchemaSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static JsonSchemaPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JsonSchemaSwitch() {
		if (modelPackage == null) {
			modelPackage = JsonSchemaPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case JsonSchemaPackage.JSON_SCHEMA: {
				JsonSchema jsonSchema = (JsonSchema)theEObject;
				T result = caseJsonSchema(jsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.PROPERTY: {
				@SuppressWarnings("unchecked") Map.Entry<String, JsonSchema> property = (Map.Entry<String, JsonSchema>)theEObject;
				T result = caseProperty(property);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.ARRAY_JSON_SCHEMA: {
				ArrayJsonSchema arrayJsonSchema = (ArrayJsonSchema)theEObject;
				T result = caseArrayJsonSchema(arrayJsonSchema);
				if (result == null) result = caseJsonSchema(arrayJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.ENUM_JSON_SCHEMA: {
				EnumJsonSchema enumJsonSchema = (EnumJsonSchema)theEObject;
				T result = caseEnumJsonSchema(enumJsonSchema);
				if (result == null) result = caseJsonSchema(enumJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.ECLASS_JSON_SCHEMA: {
				EClassJsonSchema eClassJsonSchema = (EClassJsonSchema)theEObject;
				T result = caseEClassJsonSchema(eClassJsonSchema);
				if (result == null) result = caseJsonSchema(eClassJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.EDATA_TYPE_JSON_SCHEMA: {
				EDataTypeJsonSchema eDataTypeJsonSchema = (EDataTypeJsonSchema)theEObject;
				T result = caseEDataTypeJsonSchema(eDataTypeJsonSchema);
				if (result == null) result = caseJsonSchema(eDataTypeJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.REFERENCE_JSON_SCHEMA: {
				ReferenceJsonSchema referenceJsonSchema = (ReferenceJsonSchema)theEObject;
				T result = caseReferenceJsonSchema(referenceJsonSchema);
				if (result == null) result = caseJsonSchema(referenceJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.JSON_SCHEMA_DEFINITION: {
				JsonSchemaDefinition jsonSchemaDefinition = (JsonSchemaDefinition)theEObject;
				T result = caseJsonSchemaDefinition(jsonSchemaDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case JsonSchemaPackage.ARTIFICIAL_ECLASS_JSON_SCHEMA: {
				ArtificialEClassJsonSchema artificialEClassJsonSchema = (ArtificialEClassJsonSchema)theEObject;
				T result = caseArtificialEClassJsonSchema(artificialEClassJsonSchema);
				if (result == null) result = caseJsonSchema(artificialEClassJsonSchema);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJsonSchema(JsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProperty(Map.Entry<String, JsonSchema> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayJsonSchema(ArrayJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Enum Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Enum Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnumJsonSchema(EnumJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EClass Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EClass Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEClassJsonSchema(EClassJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EData Type Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EData Type Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEDataTypeJsonSchema(EDataTypeJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reference Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reference Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferenceJsonSchema(ReferenceJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJsonSchemaDefinition(JsonSchemaDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Artificial EClass Json Schema</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Artificial EClass Json Schema</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArtificialEClassJsonSchema(ArtificialEClassJsonSchema object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //JsonSchemaSwitch
