/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.model.apisix.ApisixFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = ApisixPackage.eNS_URI, genModel = "/model/apisix.genmodel", genModelSourceLocations = {"model/apisix.genmodel","org.eclipse.fennec.apisix.api/model/apisix.genmodel"}, ecore="/model/apisix.ecore", ecoreSourceLocations="/model/apisix.ecore")
public interface ApisixPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "apisix";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.gecko.org/mac/apisix/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "apisix";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ApisixPackage eINSTANCE = org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.RouteImpl <em>Route</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.RouteImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getRoute()
	 * @generated
	 */
	int ROUTE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__ID = 0;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__URI = 1;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__METHODS = 2;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__PRIORITY = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Upstream</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__UPSTREAM = 5;

	/**
	 * The feature id for the '<em><b>Plugins</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__PLUGINS = 6;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE__LABELS = 7;

	/**
	 * The number of structural features of the '<em>Route</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Route</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUTE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.UpstreamImpl <em>Upstream</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.UpstreamImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getUpstream()
	 * @generated
	 */
	int UPSTREAM = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM__NODES = 1;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM__TIMEOUT = 2;

	/**
	 * The number of structural features of the '<em>Upstream</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Upstream</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.UpstreamNodeImpl <em>Upstream Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.UpstreamNodeImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getUpstreamNode()
	 * @generated
	 */
	int UPSTREAM_NODE = 2;

	/**
	 * The feature id for the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_NODE__HOST = 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_NODE__PORT = 1;

	/**
	 * The feature id for the '<em><b>Weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_NODE__WEIGHT = 2;

	/**
	 * The number of structural features of the '<em>Upstream Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_NODE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Upstream Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UPSTREAM_NODE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.TimeoutImpl <em>Timeout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.TimeoutImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getTimeout()
	 * @generated
	 */
	int TIMEOUT = 3;

	/**
	 * The feature id for the '<em><b>Connect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMEOUT__CONNECT = 0;

	/**
	 * The feature id for the '<em><b>Send</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMEOUT__SEND = 1;

	/**
	 * The feature id for the '<em><b>Read</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMEOUT__READ = 2;

	/**
	 * The number of structural features of the '<em>Timeout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMEOUT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Timeout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMEOUT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.PluginImpl <em>Plugin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.PluginImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getPlugin()
	 * @generated
	 */
	int PLUGIN = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUGIN__NAME = 0;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUGIN__ENABLED = 1;

	/**
	 * The number of structural features of the '<em>Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUGIN_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUGIN_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.ProxyRewritePluginImpl <em>Proxy Rewrite Plugin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.ProxyRewritePluginImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getProxyRewritePlugin()
	 * @generated
	 */
	int PROXY_REWRITE_PLUGIN = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN__NAME = PLUGIN__NAME;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN__ENABLED = PLUGIN__ENABLED;

	/**
	 * The feature id for the '<em><b>Regex Uri</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN__REGEX_URI = PLUGIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN__URI = PLUGIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Proxy Rewrite Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN_FEATURE_COUNT = PLUGIN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Proxy Rewrite Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROXY_REWRITE_PLUGIN_OPERATION_COUNT = PLUGIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl <em>Rate Limit Plugin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getRateLimitPlugin()
	 * @generated
	 */
	int RATE_LIMIT_PLUGIN = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN__NAME = PLUGIN__NAME;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN__ENABLED = PLUGIN__ENABLED;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN__COUNT = PLUGIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time Window</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN__TIME_WINDOW = PLUGIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rate Limit Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN_FEATURE_COUNT = PLUGIN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Rate Limit Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_LIMIT_PLUGIN_OPERATION_COUNT = PLUGIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.CorsPluginImpl <em>Cors Plugin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.CorsPluginImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getCorsPlugin()
	 * @generated
	 */
	int CORS_PLUGIN = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN__NAME = PLUGIN__NAME;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN__ENABLED = PLUGIN__ENABLED;

	/**
	 * The feature id for the '<em><b>Allow Origins</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN__ALLOW_ORIGINS = PLUGIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Methods</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN__ALLOW_METHODS = PLUGIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Cors Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN_FEATURE_COUNT = PLUGIN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Cors Plugin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORS_PLUGIN_OPERATION_COUNT = PLUGIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.impl.LabelImpl <em>Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.impl.LabelImpl
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getLabel()
	 * @generated
	 */
	int LABEL = 8;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.HttpMethod <em>Http Method</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.HttpMethod
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getHttpMethod()
	 * @generated
	 */
	int HTTP_METHOD = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.model.apisix.LoadBalancerType <em>Load Balancer Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.model.apisix.LoadBalancerType
	 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getLoadBalancerType()
	 * @generated
	 */
	int LOAD_BALANCER_TYPE = 10;


	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.Route <em>Route</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Route</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route
	 * @generated
	 */
	EClass getRoute();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Route#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getId()
	 * @see #getRoute()
	 * @generated
	 */
	EAttribute getRoute_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Route#getUri <em>Uri</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uri</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getUri()
	 * @see #getRoute()
	 * @generated
	 */
	EAttribute getRoute_Uri();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.model.apisix.Route#getMethods <em>Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Methods</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getMethods()
	 * @see #getRoute()
	 * @generated
	 */
	EAttribute getRoute_Methods();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Route#getPriority <em>Priority</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Priority</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getPriority()
	 * @see #getRoute()
	 * @generated
	 */
	EAttribute getRoute_Priority();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Route#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getName()
	 * @see #getRoute()
	 * @generated
	 */
	EAttribute getRoute_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.model.apisix.Route#getUpstream <em>Upstream</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upstream</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getUpstream()
	 * @see #getRoute()
	 * @generated
	 */
	EReference getRoute_Upstream();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.model.apisix.Route#getPlugins <em>Plugins</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Plugins</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getPlugins()
	 * @see #getRoute()
	 * @generated
	 */
	EReference getRoute_Plugins();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.model.apisix.Route#getLabels <em>Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Labels</em>'.
	 * @see org.eclipse.fennec.model.apisix.Route#getLabels()
	 * @see #getRoute()
	 * @generated
	 */
	EReference getRoute_Labels();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.Upstream <em>Upstream</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Upstream</em>'.
	 * @see org.eclipse.fennec.model.apisix.Upstream
	 * @generated
	 */
	EClass getUpstream();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Upstream#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.model.apisix.Upstream#getType()
	 * @see #getUpstream()
	 * @generated
	 */
	EAttribute getUpstream_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.model.apisix.Upstream#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nodes</em>'.
	 * @see org.eclipse.fennec.model.apisix.Upstream#getNodes()
	 * @see #getUpstream()
	 * @generated
	 */
	EReference getUpstream_Nodes();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.model.apisix.Upstream#getTimeout <em>Timeout</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Timeout</em>'.
	 * @see org.eclipse.fennec.model.apisix.Upstream#getTimeout()
	 * @see #getUpstream()
	 * @generated
	 */
	EReference getUpstream_Timeout();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.UpstreamNode <em>Upstream Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Upstream Node</em>'.
	 * @see org.eclipse.fennec.model.apisix.UpstreamNode
	 * @generated
	 */
	EClass getUpstreamNode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.UpstreamNode#getHost <em>Host</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host</em>'.
	 * @see org.eclipse.fennec.model.apisix.UpstreamNode#getHost()
	 * @see #getUpstreamNode()
	 * @generated
	 */
	EAttribute getUpstreamNode_Host();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.UpstreamNode#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see org.eclipse.fennec.model.apisix.UpstreamNode#getPort()
	 * @see #getUpstreamNode()
	 * @generated
	 */
	EAttribute getUpstreamNode_Port();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.UpstreamNode#getWeight <em>Weight</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weight</em>'.
	 * @see org.eclipse.fennec.model.apisix.UpstreamNode#getWeight()
	 * @see #getUpstreamNode()
	 * @generated
	 */
	EAttribute getUpstreamNode_Weight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.Timeout <em>Timeout</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Timeout</em>'.
	 * @see org.eclipse.fennec.model.apisix.Timeout
	 * @generated
	 */
	EClass getTimeout();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Timeout#getConnect <em>Connect</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Connect</em>'.
	 * @see org.eclipse.fennec.model.apisix.Timeout#getConnect()
	 * @see #getTimeout()
	 * @generated
	 */
	EAttribute getTimeout_Connect();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Timeout#getSend <em>Send</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Send</em>'.
	 * @see org.eclipse.fennec.model.apisix.Timeout#getSend()
	 * @see #getTimeout()
	 * @generated
	 */
	EAttribute getTimeout_Send();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Timeout#getRead <em>Read</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Read</em>'.
	 * @see org.eclipse.fennec.model.apisix.Timeout#getRead()
	 * @see #getTimeout()
	 * @generated
	 */
	EAttribute getTimeout_Read();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.Plugin <em>Plugin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Plugin</em>'.
	 * @see org.eclipse.fennec.model.apisix.Plugin
	 * @generated
	 */
	EClass getPlugin();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Plugin#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.model.apisix.Plugin#getName()
	 * @see #getPlugin()
	 * @generated
	 */
	EAttribute getPlugin_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Plugin#isEnabled <em>Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enabled</em>'.
	 * @see org.eclipse.fennec.model.apisix.Plugin#isEnabled()
	 * @see #getPlugin()
	 * @generated
	 */
	EAttribute getPlugin_Enabled();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin <em>Proxy Rewrite Plugin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Proxy Rewrite Plugin</em>'.
	 * @see org.eclipse.fennec.model.apisix.ProxyRewritePlugin
	 * @generated
	 */
	EClass getProxyRewritePlugin();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getRegexUri <em>Regex Uri</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Regex Uri</em>'.
	 * @see org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getRegexUri()
	 * @see #getProxyRewritePlugin()
	 * @generated
	 */
	EAttribute getProxyRewritePlugin_RegexUri();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getUri <em>Uri</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uri</em>'.
	 * @see org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getUri()
	 * @see #getProxyRewritePlugin()
	 * @generated
	 */
	EAttribute getProxyRewritePlugin_Uri();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.RateLimitPlugin <em>Rate Limit Plugin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rate Limit Plugin</em>'.
	 * @see org.eclipse.fennec.model.apisix.RateLimitPlugin
	 * @generated
	 */
	EClass getRateLimitPlugin();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.fennec.model.apisix.RateLimitPlugin#getCount()
	 * @see #getRateLimitPlugin()
	 * @generated
	 */
	EAttribute getRateLimitPlugin_Count();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getTimeWindow <em>Time Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time Window</em>'.
	 * @see org.eclipse.fennec.model.apisix.RateLimitPlugin#getTimeWindow()
	 * @see #getRateLimitPlugin()
	 * @generated
	 */
	EAttribute getRateLimitPlugin_TimeWindow();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.CorsPlugin <em>Cors Plugin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cors Plugin</em>'.
	 * @see org.eclipse.fennec.model.apisix.CorsPlugin
	 * @generated
	 */
	EClass getCorsPlugin();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.model.apisix.CorsPlugin#getAllowOrigins <em>Allow Origins</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Allow Origins</em>'.
	 * @see org.eclipse.fennec.model.apisix.CorsPlugin#getAllowOrigins()
	 * @see #getCorsPlugin()
	 * @generated
	 */
	EAttribute getCorsPlugin_AllowOrigins();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.model.apisix.CorsPlugin#getAllowMethods <em>Allow Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Allow Methods</em>'.
	 * @see org.eclipse.fennec.model.apisix.CorsPlugin#getAllowMethods()
	 * @see #getCorsPlugin()
	 * @generated
	 */
	EAttribute getCorsPlugin_AllowMethods();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.model.apisix.Label <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Label</em>'.
	 * @see org.eclipse.fennec.model.apisix.Label
	 * @generated
	 */
	EClass getLabel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Label#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.eclipse.fennec.model.apisix.Label#getKey()
	 * @see #getLabel()
	 * @generated
	 */
	EAttribute getLabel_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.model.apisix.Label#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.fennec.model.apisix.Label#getValue()
	 * @see #getLabel()
	 * @generated
	 */
	EAttribute getLabel_Value();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.model.apisix.HttpMethod <em>Http Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Http Method</em>'.
	 * @see org.eclipse.fennec.model.apisix.HttpMethod
	 * @generated
	 */
	EEnum getHttpMethod();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.model.apisix.LoadBalancerType <em>Load Balancer Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Load Balancer Type</em>'.
	 * @see org.eclipse.fennec.model.apisix.LoadBalancerType
	 * @generated
	 */
	EEnum getLoadBalancerType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ApisixFactory getApisixFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.RouteImpl <em>Route</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.RouteImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getRoute()
		 * @generated
		 */
		EClass ROUTE = eINSTANCE.getRoute();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROUTE__ID = eINSTANCE.getRoute_Id();

		/**
		 * The meta object literal for the '<em><b>Uri</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROUTE__URI = eINSTANCE.getRoute_Uri();

		/**
		 * The meta object literal for the '<em><b>Methods</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROUTE__METHODS = eINSTANCE.getRoute_Methods();

		/**
		 * The meta object literal for the '<em><b>Priority</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROUTE__PRIORITY = eINSTANCE.getRoute_Priority();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROUTE__NAME = eINSTANCE.getRoute_Name();

		/**
		 * The meta object literal for the '<em><b>Upstream</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROUTE__UPSTREAM = eINSTANCE.getRoute_Upstream();

		/**
		 * The meta object literal for the '<em><b>Plugins</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROUTE__PLUGINS = eINSTANCE.getRoute_Plugins();

		/**
		 * The meta object literal for the '<em><b>Labels</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROUTE__LABELS = eINSTANCE.getRoute_Labels();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.UpstreamImpl <em>Upstream</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.UpstreamImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getUpstream()
		 * @generated
		 */
		EClass UPSTREAM = eINSTANCE.getUpstream();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPSTREAM__TYPE = eINSTANCE.getUpstream_Type();

		/**
		 * The meta object literal for the '<em><b>Nodes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UPSTREAM__NODES = eINSTANCE.getUpstream_Nodes();

		/**
		 * The meta object literal for the '<em><b>Timeout</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UPSTREAM__TIMEOUT = eINSTANCE.getUpstream_Timeout();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.UpstreamNodeImpl <em>Upstream Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.UpstreamNodeImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getUpstreamNode()
		 * @generated
		 */
		EClass UPSTREAM_NODE = eINSTANCE.getUpstreamNode();

		/**
		 * The meta object literal for the '<em><b>Host</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPSTREAM_NODE__HOST = eINSTANCE.getUpstreamNode_Host();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPSTREAM_NODE__PORT = eINSTANCE.getUpstreamNode_Port();

		/**
		 * The meta object literal for the '<em><b>Weight</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UPSTREAM_NODE__WEIGHT = eINSTANCE.getUpstreamNode_Weight();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.TimeoutImpl <em>Timeout</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.TimeoutImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getTimeout()
		 * @generated
		 */
		EClass TIMEOUT = eINSTANCE.getTimeout();

		/**
		 * The meta object literal for the '<em><b>Connect</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIMEOUT__CONNECT = eINSTANCE.getTimeout_Connect();

		/**
		 * The meta object literal for the '<em><b>Send</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIMEOUT__SEND = eINSTANCE.getTimeout_Send();

		/**
		 * The meta object literal for the '<em><b>Read</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TIMEOUT__READ = eINSTANCE.getTimeout_Read();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.PluginImpl <em>Plugin</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.PluginImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getPlugin()
		 * @generated
		 */
		EClass PLUGIN = eINSTANCE.getPlugin();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLUGIN__NAME = eINSTANCE.getPlugin_Name();

		/**
		 * The meta object literal for the '<em><b>Enabled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLUGIN__ENABLED = eINSTANCE.getPlugin_Enabled();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.ProxyRewritePluginImpl <em>Proxy Rewrite Plugin</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.ProxyRewritePluginImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getProxyRewritePlugin()
		 * @generated
		 */
		EClass PROXY_REWRITE_PLUGIN = eINSTANCE.getProxyRewritePlugin();

		/**
		 * The meta object literal for the '<em><b>Regex Uri</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROXY_REWRITE_PLUGIN__REGEX_URI = eINSTANCE.getProxyRewritePlugin_RegexUri();

		/**
		 * The meta object literal for the '<em><b>Uri</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROXY_REWRITE_PLUGIN__URI = eINSTANCE.getProxyRewritePlugin_Uri();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl <em>Rate Limit Plugin</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getRateLimitPlugin()
		 * @generated
		 */
		EClass RATE_LIMIT_PLUGIN = eINSTANCE.getRateLimitPlugin();

		/**
		 * The meta object literal for the '<em><b>Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RATE_LIMIT_PLUGIN__COUNT = eINSTANCE.getRateLimitPlugin_Count();

		/**
		 * The meta object literal for the '<em><b>Time Window</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RATE_LIMIT_PLUGIN__TIME_WINDOW = eINSTANCE.getRateLimitPlugin_TimeWindow();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.CorsPluginImpl <em>Cors Plugin</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.CorsPluginImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getCorsPlugin()
		 * @generated
		 */
		EClass CORS_PLUGIN = eINSTANCE.getCorsPlugin();

		/**
		 * The meta object literal for the '<em><b>Allow Origins</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CORS_PLUGIN__ALLOW_ORIGINS = eINSTANCE.getCorsPlugin_AllowOrigins();

		/**
		 * The meta object literal for the '<em><b>Allow Methods</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CORS_PLUGIN__ALLOW_METHODS = eINSTANCE.getCorsPlugin_AllowMethods();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.impl.LabelImpl <em>Label</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.impl.LabelImpl
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getLabel()
		 * @generated
		 */
		EClass LABEL = eINSTANCE.getLabel();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LABEL__KEY = eINSTANCE.getLabel_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LABEL__VALUE = eINSTANCE.getLabel_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.HttpMethod <em>Http Method</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.HttpMethod
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getHttpMethod()
		 * @generated
		 */
		EEnum HTTP_METHOD = eINSTANCE.getHttpMethod();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.model.apisix.LoadBalancerType <em>Load Balancer Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.model.apisix.LoadBalancerType
		 * @see org.eclipse.fennec.model.apisix.impl.ApisixPackageImpl#getLoadBalancerType()
		 * @generated
		 */
		EEnum LOAD_BALANCER_TYPE = eINSTANCE.getLoadBalancerType();

	}

} //ApisixPackage
