/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Cors Plugin</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Plugin for Cross-Origin Resource Sharing (CORS)
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.CorsPlugin#getAllowOrigins <em>Allow Origins</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.CorsPlugin#getAllowMethods <em>Allow Methods</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getCorsPlugin()
 * @model
 * @generated
 */
@ProviderType
public interface CorsPlugin extends Plugin {
	/**
	 * Returns the value of the '<em><b>Allow Origins</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Allowed origins for CORS
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Allow Origins</em>' attribute list.
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getCorsPlugin_AllowOrigins()
	 * @model
	 * @generated
	 */
	EList<String> getAllowOrigins();

	/**
	 * Returns the value of the '<em><b>Allow Methods</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.fennec.model.apisix.HttpMethod}.
	 * The literals are from the enumeration {@link org.eclipse.fennec.model.apisix.HttpMethod}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Allowed HTTP methods for CORS
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Allow Methods</em>' attribute list.
	 * @see org.eclipse.fennec.model.apisix.HttpMethod
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getCorsPlugin_AllowMethods()
	 * @model
	 * @generated
	 */
	EList<HttpMethod> getAllowMethods();

} // CorsPlugin
