/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Load Balancer Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Load balancing algorithms supported by APISIX
 * <!-- end-model-doc -->
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getLoadBalancerType()
 * @model
 * @generated
 */
@ProviderType
public enum LoadBalancerType implements Enumerator {
	/**
	 * The '<em><b>Roundrobin</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Round-robin load balancing (default)
	 * <!-- end-model-doc -->
	 * @see #ROUNDROBIN_VALUE
	 * @generated
	 * @ordered
	 */
	ROUNDROBIN(0, "roundrobin", "roundrobin"),

	/**
	 * The '<em><b>Chash</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Consistent hashing
	 * <!-- end-model-doc -->
	 * @see #CHASH_VALUE
	 * @generated
	 * @ordered
	 */
	CHASH(1, "chash", "chash"),

	/**
	 * The '<em><b>Least conn</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Least connections algorithm
	 * <!-- end-model-doc -->
	 * @see #LEAST_CONN_VALUE
	 * @generated
	 * @ordered
	 */
	LEAST_CONN(2, "least_conn", "least_conn");

	/**
	 * The '<em><b>Roundrobin</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Round-robin load balancing (default)
	 * <!-- end-model-doc -->
	 * @see #ROUNDROBIN
	 * @model name="roundrobin"
	 * @generated
	 * @ordered
	 */
	public static final int ROUNDROBIN_VALUE = 0;

	/**
	 * The '<em><b>Chash</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Consistent hashing
	 * <!-- end-model-doc -->
	 * @see #CHASH
	 * @model name="chash"
	 * @generated
	 * @ordered
	 */
	public static final int CHASH_VALUE = 1;

	/**
	 * The '<em><b>Least conn</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Least connections algorithm
	 * <!-- end-model-doc -->
	 * @see #LEAST_CONN
	 * @model name="least_conn"
	 * @generated
	 * @ordered
	 */
	public static final int LEAST_CONN_VALUE = 2;

	/**
	 * An array of all the '<em><b>Load Balancer Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final LoadBalancerType[] VALUES_ARRAY =
		new LoadBalancerType[] {
			ROUNDROBIN,
			CHASH,
			LEAST_CONN,
		};

	/**
	 * A public read-only list of all the '<em><b>Load Balancer Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<LoadBalancerType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Load Balancer Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LoadBalancerType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LoadBalancerType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Load Balancer Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LoadBalancerType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			LoadBalancerType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Load Balancer Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static LoadBalancerType get(int value) {
		switch (value) {
			case ROUNDROBIN_VALUE: return ROUNDROBIN;
			case CHASH_VALUE: return CHASH;
			case LEAST_CONN_VALUE: return LEAST_CONN;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private LoadBalancerType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //LoadBalancerType
