/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Proxy Rewrite Plugin</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Plugin for rewriting request paths
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getRegexUri <em>Regex Uri</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getUri <em>Uri</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getProxyRewritePlugin()
 * @model
 * @generated
 */
@ProviderType
public interface ProxyRewritePlugin extends Plugin {
	/**
	 * Returns the value of the '<em><b>Regex Uri</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Regex pattern and replacement for URI rewriting [pattern, replacement]
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Regex Uri</em>' attribute list.
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getProxyRewritePlugin_RegexUri()
	 * @model upper="2"
	 * @generated
	 */
	EList<String> getRegexUri();

	/**
	 * Returns the value of the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Static URI to rewrite to
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Uri</em>' attribute.
	 * @see #setUri(String)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getProxyRewritePlugin_Uri()
	 * @model
	 * @generated
	 */
	String getUri();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.ProxyRewritePlugin#getUri <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Uri</em>' attribute.
	 * @see #getUri()
	 * @generated
	 */
	void setUri(String value);

} // ProxyRewritePlugin
