/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rate Limit Plugin</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Plugin for rate limiting requests
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getTimeWindow <em>Time Window</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRateLimitPlugin()
 * @model
 * @generated
 */
@ProviderType
public interface RateLimitPlugin extends Plugin {
	/**
	 * Returns the value of the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maximum number of requests
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Count</em>' attribute.
	 * @see #setCount(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRateLimitPlugin_Count()
	 * @model required="true"
	 * @generated
	 */
	int getCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getCount <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Count</em>' attribute.
	 * @see #getCount()
	 * @generated
	 */
	void setCount(int value);

	/**
	 * Returns the value of the '<em><b>Time Window</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time window in seconds
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Time Window</em>' attribute.
	 * @see #setTimeWindow(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRateLimitPlugin_TimeWindow()
	 * @model required="true"
	 * @generated
	 */
	int getTimeWindow();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.RateLimitPlugin#getTimeWindow <em>Time Window</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time Window</em>' attribute.
	 * @see #getTimeWindow()
	 * @generated
	 */
	void setTimeWindow(int value);

} // RateLimitPlugin
