/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Route</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Represents an APISIX route configuration
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getUri <em>Uri</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getMethods <em>Methods</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getUpstream <em>Upstream</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getPlugins <em>Plugins</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Route#getLabels <em>Labels</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute()
 * @model
 * @generated
 */
@ProviderType
public interface Route extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier for the route
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Id()
	 * @model
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Route#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * URI pattern to match (required)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Uri</em>' attribute.
	 * @see #setUri(String)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Uri()
	 * @model required="true"
	 * @generated
	 */
	String getUri();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Route#getUri <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Uri</em>' attribute.
	 * @see #getUri()
	 * @generated
	 */
	void setUri(String value);

	/**
	 * Returns the value of the '<em><b>Methods</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.fennec.model.apisix.HttpMethod}.
	 * The literals are from the enumeration {@link org.eclipse.fennec.model.apisix.HttpMethod}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * HTTP methods to match
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Methods</em>' attribute list.
	 * @see org.eclipse.fennec.model.apisix.HttpMethod
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Methods()
	 * @model
	 * @generated
	 */
	EList<HttpMethod> getMethods();

	/**
	 * Returns the value of the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Route matching priority (higher values have higher priority)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Priority</em>' attribute.
	 * @see #setPriority(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Priority()
	 * @model
	 * @generated
	 */
	int getPriority();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Route#getPriority <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Priority</em>' attribute.
	 * @see #getPriority()
	 * @generated
	 */
	void setPriority(int value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional route name
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Route#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Upstream</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Backend upstream configuration
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Upstream</em>' containment reference.
	 * @see #setUpstream(Upstream)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Upstream()
	 * @model containment="true"
	 * @generated
	 */
	Upstream getUpstream();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Route#getUpstream <em>Upstream</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Upstream</em>' containment reference.
	 * @see #getUpstream()
	 * @generated
	 */
	void setUpstream(Upstream value);

	/**
	 * Returns the value of the '<em><b>Plugins</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.model.apisix.Plugin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Plugins applied to this route
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Plugins</em>' containment reference list.
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Plugins()
	 * @model containment="true"
	 * @generated
	 */
	EList<Plugin> getPlugins();

	/**
	 * Returns the value of the '<em><b>Labels</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.model.apisix.Label}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Metadata labels for this route
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Labels</em>' containment reference list.
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getRoute_Labels()
	 * @model containment="true"
	 * @generated
	 */
	EList<Label> getLabels();

} // Route
