/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Timeout</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Timeout configuration for upstream connections
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.Timeout#getConnect <em>Connect</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Timeout#getSend <em>Send</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Timeout#getRead <em>Read</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getTimeout()
 * @model
 * @generated
 */
@ProviderType
public interface Timeout extends EObject {
	/**
	 * Returns the value of the '<em><b>Connect</b></em>' attribute.
	 * The default value is <code>"6"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Connection timeout in seconds
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Connect</em>' attribute.
	 * @see #setConnect(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getTimeout_Connect()
	 * @model default="6"
	 * @generated
	 */
	int getConnect();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Timeout#getConnect <em>Connect</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Connect</em>' attribute.
	 * @see #getConnect()
	 * @generated
	 */
	void setConnect(int value);

	/**
	 * Returns the value of the '<em><b>Send</b></em>' attribute.
	 * The default value is <code>"6"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Send timeout in seconds
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Send</em>' attribute.
	 * @see #setSend(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getTimeout_Send()
	 * @model default="6"
	 * @generated
	 */
	int getSend();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Timeout#getSend <em>Send</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Send</em>' attribute.
	 * @see #getSend()
	 * @generated
	 */
	void setSend(int value);

	/**
	 * Returns the value of the '<em><b>Read</b></em>' attribute.
	 * The default value is <code>"6"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Read timeout in seconds
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Read</em>' attribute.
	 * @see #setRead(int)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getTimeout_Read()
	 * @model default="6"
	 * @generated
	 */
	int getRead();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Timeout#getRead <em>Read</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Read</em>' attribute.
	 * @see #getRead()
	 * @generated
	 */
	void setRead(int value);

} // Timeout
