/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Upstream</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Backend upstream service configuration
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.Upstream#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Upstream#getNodes <em>Nodes</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.Upstream#getTimeout <em>Timeout</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getUpstream()
 * @model
 * @generated
 */
@ProviderType
public interface Upstream extends EObject {
	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The default value is <code>"roundrobin"</code>.
	 * The literals are from the enumeration {@link org.eclipse.fennec.model.apisix.LoadBalancerType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Load balancing algorithm
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.fennec.model.apisix.LoadBalancerType
	 * @see #setType(LoadBalancerType)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getUpstream_Type()
	 * @model default="roundrobin" required="true"
	 * @generated
	 */
	LoadBalancerType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Upstream#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.fennec.model.apisix.LoadBalancerType
	 * @see #getType()
	 * @generated
	 */
	void setType(LoadBalancerType value);

	/**
	 * Returns the value of the '<em><b>Nodes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.model.apisix.UpstreamNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Backend server nodes
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Nodes</em>' containment reference list.
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getUpstream_Nodes()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<UpstreamNode> getNodes();

	/**
	 * Returns the value of the '<em><b>Timeout</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Connection timeout settings
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Timeout</em>' containment reference.
	 * @see #setTimeout(Timeout)
	 * @see org.eclipse.fennec.model.apisix.ApisixPackage#getUpstream_Timeout()
	 * @model containment="true"
	 * @generated
	 */
	Timeout getTimeout();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.model.apisix.Upstream#getTimeout <em>Timeout</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timeout</em>' containment reference.
	 * @see #getTimeout()
	 * @generated
	 */
	void setTimeout(Timeout value);

} // Upstream
