/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.fennec.model.apisix.ApisixPackage;
import org.eclipse.fennec.model.apisix.CorsPlugin;
import org.eclipse.fennec.model.apisix.HttpMethod;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Cors Plugin</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.CorsPluginImpl#getAllowOrigins <em>Allow Origins</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.CorsPluginImpl#getAllowMethods <em>Allow Methods</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CorsPluginImpl extends PluginImpl implements CorsPlugin {
	/**
	 * The cached value of the '{@link #getAllowOrigins() <em>Allow Origins</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllowOrigins()
	 * @generated
	 * @ordered
	 */
	protected EList<String> allowOrigins;

	/**
	 * The cached value of the '{@link #getAllowMethods() <em>Allow Methods</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllowMethods()
	 * @generated
	 * @ordered
	 */
	protected EList<HttpMethod> allowMethods;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorsPluginImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ApisixPackage.Literals.CORS_PLUGIN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getAllowOrigins() {
		if (allowOrigins == null) {
			allowOrigins = new EDataTypeUniqueEList<String>(String.class, this, ApisixPackage.CORS_PLUGIN__ALLOW_ORIGINS);
		}
		return allowOrigins;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HttpMethod> getAllowMethods() {
		if (allowMethods == null) {
			allowMethods = new EDataTypeUniqueEList<HttpMethod>(HttpMethod.class, this, ApisixPackage.CORS_PLUGIN__ALLOW_METHODS);
		}
		return allowMethods;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ApisixPackage.CORS_PLUGIN__ALLOW_ORIGINS:
				return getAllowOrigins();
			case ApisixPackage.CORS_PLUGIN__ALLOW_METHODS:
				return getAllowMethods();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ApisixPackage.CORS_PLUGIN__ALLOW_ORIGINS:
				getAllowOrigins().clear();
				getAllowOrigins().addAll((Collection<? extends String>)newValue);
				return;
			case ApisixPackage.CORS_PLUGIN__ALLOW_METHODS:
				getAllowMethods().clear();
				getAllowMethods().addAll((Collection<? extends HttpMethod>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ApisixPackage.CORS_PLUGIN__ALLOW_ORIGINS:
				getAllowOrigins().clear();
				return;
			case ApisixPackage.CORS_PLUGIN__ALLOW_METHODS:
				getAllowMethods().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ApisixPackage.CORS_PLUGIN__ALLOW_ORIGINS:
				return allowOrigins != null && !allowOrigins.isEmpty();
			case ApisixPackage.CORS_PLUGIN__ALLOW_METHODS:
				return allowMethods != null && !allowMethods.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (allowOrigins: ");
		result.append(allowOrigins);
		result.append(", allowMethods: ");
		result.append(allowMethods);
		result.append(')');
		return result.toString();
	}

} //CorsPluginImpl
