/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.fennec.model.apisix.ApisixPackage;
import org.eclipse.fennec.model.apisix.RateLimitPlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rate Limit Plugin</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl#getCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RateLimitPluginImpl#getTimeWindow <em>Time Window</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RateLimitPluginImpl extends PluginImpl implements RateLimitPlugin {
	/**
	 * The default value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected static final int COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected int count = COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimeWindow() <em>Time Window</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeWindow()
	 * @generated
	 * @ordered
	 */
	protected static final int TIME_WINDOW_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTimeWindow() <em>Time Window</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeWindow()
	 * @generated
	 * @ordered
	 */
	protected int timeWindow = TIME_WINDOW_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RateLimitPluginImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ApisixPackage.Literals.RATE_LIMIT_PLUGIN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCount(int newCount) {
		int oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.RATE_LIMIT_PLUGIN__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getTimeWindow() {
		return timeWindow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimeWindow(int newTimeWindow) {
		int oldTimeWindow = timeWindow;
		timeWindow = newTimeWindow;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.RATE_LIMIT_PLUGIN__TIME_WINDOW, oldTimeWindow, timeWindow));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ApisixPackage.RATE_LIMIT_PLUGIN__COUNT:
				return getCount();
			case ApisixPackage.RATE_LIMIT_PLUGIN__TIME_WINDOW:
				return getTimeWindow();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ApisixPackage.RATE_LIMIT_PLUGIN__COUNT:
				setCount((Integer)newValue);
				return;
			case ApisixPackage.RATE_LIMIT_PLUGIN__TIME_WINDOW:
				setTimeWindow((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ApisixPackage.RATE_LIMIT_PLUGIN__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ApisixPackage.RATE_LIMIT_PLUGIN__TIME_WINDOW:
				setTimeWindow(TIME_WINDOW_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ApisixPackage.RATE_LIMIT_PLUGIN__COUNT:
				return count != COUNT_EDEFAULT;
			case ApisixPackage.RATE_LIMIT_PLUGIN__TIME_WINDOW:
				return timeWindow != TIME_WINDOW_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (count: ");
		result.append(count);
		result.append(", timeWindow: ");
		result.append(timeWindow);
		result.append(')');
		return result.toString();
	}

} //RateLimitPluginImpl
