/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.model.apisix.ApisixPackage;
import org.eclipse.fennec.model.apisix.HttpMethod;
import org.eclipse.fennec.model.apisix.Label;
import org.eclipse.fennec.model.apisix.Plugin;
import org.eclipse.fennec.model.apisix.Route;
import org.eclipse.fennec.model.apisix.Upstream;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Route</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getUri <em>Uri</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getMethods <em>Methods</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getUpstream <em>Upstream</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getPlugins <em>Plugins</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.RouteImpl#getLabels <em>Labels</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RouteImpl extends MinimalEObjectImpl.Container implements Route {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getUri() <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUri()
	 * @generated
	 * @ordered
	 */
	protected static final String URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUri() <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUri()
	 * @generated
	 * @ordered
	 */
	protected String uri = URI_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMethods() <em>Methods</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethods()
	 * @generated
	 * @ordered
	 */
	protected EList<HttpMethod> methods;

	/**
	 * The default value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected static final int PRIORITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected int priority = PRIORITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUpstream() <em>Upstream</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUpstream()
	 * @generated
	 * @ordered
	 */
	protected Upstream upstream;

	/**
	 * The cached value of the '{@link #getPlugins() <em>Plugins</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlugins()
	 * @generated
	 * @ordered
	 */
	protected EList<Plugin> plugins;

	/**
	 * The cached value of the '{@link #getLabels() <em>Labels</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabels()
	 * @generated
	 * @ordered
	 */
	protected EList<Label> labels;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RouteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ApisixPackage.Literals.ROUTE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUri() {
		return uri;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUri(String newUri) {
		String oldUri = uri;
		uri = newUri;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__URI, oldUri, uri));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<HttpMethod> getMethods() {
		if (methods == null) {
			methods = new EDataTypeUniqueEList<HttpMethod>(HttpMethod.class, this, ApisixPackage.ROUTE__METHODS);
		}
		return methods;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getPriority() {
		return priority;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPriority(int newPriority) {
		int oldPriority = priority;
		priority = newPriority;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__PRIORITY, oldPriority, priority));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Upstream getUpstream() {
		return upstream;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUpstream(Upstream newUpstream, NotificationChain msgs) {
		Upstream oldUpstream = upstream;
		upstream = newUpstream;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__UPSTREAM, oldUpstream, newUpstream);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUpstream(Upstream newUpstream) {
		if (newUpstream != upstream) {
			NotificationChain msgs = null;
			if (upstream != null)
				msgs = ((InternalEObject)upstream).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ApisixPackage.ROUTE__UPSTREAM, null, msgs);
			if (newUpstream != null)
				msgs = ((InternalEObject)newUpstream).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ApisixPackage.ROUTE__UPSTREAM, null, msgs);
			msgs = basicSetUpstream(newUpstream, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.ROUTE__UPSTREAM, newUpstream, newUpstream));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Plugin> getPlugins() {
		if (plugins == null) {
			plugins = new EObjectContainmentEList<Plugin>(Plugin.class, this, ApisixPackage.ROUTE__PLUGINS);
		}
		return plugins;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Label> getLabels() {
		if (labels == null) {
			labels = new EObjectContainmentEList<Label>(Label.class, this, ApisixPackage.ROUTE__LABELS);
		}
		return labels;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ApisixPackage.ROUTE__UPSTREAM:
				return basicSetUpstream(null, msgs);
			case ApisixPackage.ROUTE__PLUGINS:
				return ((InternalEList<?>)getPlugins()).basicRemove(otherEnd, msgs);
			case ApisixPackage.ROUTE__LABELS:
				return ((InternalEList<?>)getLabels()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ApisixPackage.ROUTE__ID:
				return getId();
			case ApisixPackage.ROUTE__URI:
				return getUri();
			case ApisixPackage.ROUTE__METHODS:
				return getMethods();
			case ApisixPackage.ROUTE__PRIORITY:
				return getPriority();
			case ApisixPackage.ROUTE__NAME:
				return getName();
			case ApisixPackage.ROUTE__UPSTREAM:
				return getUpstream();
			case ApisixPackage.ROUTE__PLUGINS:
				return getPlugins();
			case ApisixPackage.ROUTE__LABELS:
				return getLabels();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ApisixPackage.ROUTE__ID:
				setId((String)newValue);
				return;
			case ApisixPackage.ROUTE__URI:
				setUri((String)newValue);
				return;
			case ApisixPackage.ROUTE__METHODS:
				getMethods().clear();
				getMethods().addAll((Collection<? extends HttpMethod>)newValue);
				return;
			case ApisixPackage.ROUTE__PRIORITY:
				setPriority((Integer)newValue);
				return;
			case ApisixPackage.ROUTE__NAME:
				setName((String)newValue);
				return;
			case ApisixPackage.ROUTE__UPSTREAM:
				setUpstream((Upstream)newValue);
				return;
			case ApisixPackage.ROUTE__PLUGINS:
				getPlugins().clear();
				getPlugins().addAll((Collection<? extends Plugin>)newValue);
				return;
			case ApisixPackage.ROUTE__LABELS:
				getLabels().clear();
				getLabels().addAll((Collection<? extends Label>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ApisixPackage.ROUTE__ID:
				setId(ID_EDEFAULT);
				return;
			case ApisixPackage.ROUTE__URI:
				setUri(URI_EDEFAULT);
				return;
			case ApisixPackage.ROUTE__METHODS:
				getMethods().clear();
				return;
			case ApisixPackage.ROUTE__PRIORITY:
				setPriority(PRIORITY_EDEFAULT);
				return;
			case ApisixPackage.ROUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ApisixPackage.ROUTE__UPSTREAM:
				setUpstream((Upstream)null);
				return;
			case ApisixPackage.ROUTE__PLUGINS:
				getPlugins().clear();
				return;
			case ApisixPackage.ROUTE__LABELS:
				getLabels().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ApisixPackage.ROUTE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ApisixPackage.ROUTE__URI:
				return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT.equals(uri);
			case ApisixPackage.ROUTE__METHODS:
				return methods != null && !methods.isEmpty();
			case ApisixPackage.ROUTE__PRIORITY:
				return priority != PRIORITY_EDEFAULT;
			case ApisixPackage.ROUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ApisixPackage.ROUTE__UPSTREAM:
				return upstream != null;
			case ApisixPackage.ROUTE__PLUGINS:
				return plugins != null && !plugins.isEmpty();
			case ApisixPackage.ROUTE__LABELS:
				return labels != null && !labels.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", uri: ");
		result.append(uri);
		result.append(", methods: ");
		result.append(methods);
		result.append(", priority: ");
		result.append(priority);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //RouteImpl
