/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.model.apisix.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.model.apisix.ApisixPackage;
import org.eclipse.fennec.model.apisix.Timeout;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Timeout</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.TimeoutImpl#getConnect <em>Connect</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.TimeoutImpl#getSend <em>Send</em>}</li>
 *   <li>{@link org.eclipse.fennec.model.apisix.impl.TimeoutImpl#getRead <em>Read</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TimeoutImpl extends MinimalEObjectImpl.Container implements Timeout {
	/**
	 * The default value of the '{@link #getConnect() <em>Connect</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConnect()
	 * @generated
	 * @ordered
	 */
	protected static final int CONNECT_EDEFAULT = 6;

	/**
	 * The cached value of the '{@link #getConnect() <em>Connect</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConnect()
	 * @generated
	 * @ordered
	 */
	protected int connect = CONNECT_EDEFAULT;

	/**
	 * The default value of the '{@link #getSend() <em>Send</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSend()
	 * @generated
	 * @ordered
	 */
	protected static final int SEND_EDEFAULT = 6;

	/**
	 * The cached value of the '{@link #getSend() <em>Send</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSend()
	 * @generated
	 * @ordered
	 */
	protected int send = SEND_EDEFAULT;

	/**
	 * The default value of the '{@link #getRead() <em>Read</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRead()
	 * @generated
	 * @ordered
	 */
	protected static final int READ_EDEFAULT = 6;

	/**
	 * The cached value of the '{@link #getRead() <em>Read</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRead()
	 * @generated
	 * @ordered
	 */
	protected int read = READ_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeoutImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ApisixPackage.Literals.TIMEOUT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getConnect() {
		return connect;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConnect(int newConnect) {
		int oldConnect = connect;
		connect = newConnect;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.TIMEOUT__CONNECT, oldConnect, connect));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getSend() {
		return send;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSend(int newSend) {
		int oldSend = send;
		send = newSend;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.TIMEOUT__SEND, oldSend, send));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getRead() {
		return read;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRead(int newRead) {
		int oldRead = read;
		read = newRead;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ApisixPackage.TIMEOUT__READ, oldRead, read));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ApisixPackage.TIMEOUT__CONNECT:
				return getConnect();
			case ApisixPackage.TIMEOUT__SEND:
				return getSend();
			case ApisixPackage.TIMEOUT__READ:
				return getRead();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ApisixPackage.TIMEOUT__CONNECT:
				setConnect((Integer)newValue);
				return;
			case ApisixPackage.TIMEOUT__SEND:
				setSend((Integer)newValue);
				return;
			case ApisixPackage.TIMEOUT__READ:
				setRead((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ApisixPackage.TIMEOUT__CONNECT:
				setConnect(CONNECT_EDEFAULT);
				return;
			case ApisixPackage.TIMEOUT__SEND:
				setSend(SEND_EDEFAULT);
				return;
			case ApisixPackage.TIMEOUT__READ:
				setRead(READ_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ApisixPackage.TIMEOUT__CONNECT:
				return connect != CONNECT_EDEFAULT;
			case ApisixPackage.TIMEOUT__SEND:
				return send != SEND_EDEFAULT;
			case ApisixPackage.TIMEOUT__READ:
				return read != READ_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (connect: ");
		result.append(connect);
		result.append(", send: ");
		result.append(send);
		result.append(", read: ");
		result.append(read);
		result.append(')');
		return result.toString();
	}

} //TimeoutImpl
