/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.apisix;

import org.eclipse.fennec.model.apisix.Route;

/**
 * Eclipse Modeling Fennec APISIX client interface for managing API Gateway routes.
 * 
 * <p>This client provides a high-level API for managing APISIX routes using the Eclipse Modeling
 * Framework (EMF) model objects. Routes are automatically serialized to JSON via EMF message body
 * writers for seamless integration with the APISIX Admin API.</p>
 * 
 * <p>Part of the Eclipse Modeling Fennec project for OSGi-based API Gateway integration.</p>
 * 
 * @author Mark Hoffmann
 * @since 17.09.2025
 */
public interface ApiSixClient {

	/**
	 * Creates a route in APISIX using the Eclipse EMF Route model.
	 * The route configuration is automatically serialized to JSON and submitted to the APISIX Admin API.
	 * 
	 * @param route the EMF Route model object containing the route configuration
	 */
	void createRoute(Route route);

	/**
	 * Deletes a route from APISIX by its unique identifier.
	 * 
	 * @param routeId the unique identifier of the route to delete
	 */
	void deleteRoute(String routeId);

}