/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.jakarta.runtime.whiteboard.api;

import org.eclipse.fennec.jakarta.runtime.whiteboard.dto.RuntimeChangeEvent;

/**
 * Service interface for listening to Jakarta REST runtime changes.
 * 
 * <p>Implementations of this interface will be automatically discovered
 * and notified when resources are added, modified, or removed from
 * the Jakarta REST runtime.</p>
 * 
 * <p>This follows the OSGi whiteboard pattern - simply register a service
 * implementing this interface and it will automatically receive notifications.</p>
 * 
 * @author Mark Hoffmann
 * @since 04.10.2025
 */
public interface JakartaRuntimeChangeListener {

    /**
     * Called when resources are added to the Jakarta REST runtime.
     * 
     * @param event the runtime change event containing added resources
     */
    void onResourcesAdded(RuntimeChangeEvent event);

    /**
     * Called when resources are removed from the Jakarta REST runtime.
     * 
     * @param event the runtime change event containing removed resources
     */
    void onResourcesRemoved(RuntimeChangeEvent event);

    /**
     * Called when existing resources are modified in the Jakarta REST runtime.
     * This occurs when resource properties change but the service ID remains the same.
     * 
     * @param event the runtime change event containing modified resources
     */
    void onResourcesModified(RuntimeChangeEvent event);

    /**
     * Called when the runtime configuration changes (e.g., endpoints change).
     * 
     * @param event the runtime change event containing runtime information
     */
    void onRuntimeChanged(RuntimeChangeEvent event);

}