/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.openapi.tests;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;
import org.osgi.test.junit5.cm.ConfigurationExtension;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

/**
 * 
 * @author mark
 * @since 05.10.2025
 */
@ExtendWith(ConfigurationExtension.class)
@ExtendWith(BundleContextExtension.class)
@ExtendWith(ServiceExtension.class)
public class OpenApiGeneratorIntegrationTest extends BaseOpenApiIntegrationTest {
	
	@BeforeEach
	public void setup(@InjectBundleContext BundleContext ctx) {
		super.setup(ctx);
	}

	@AfterEach
	public void cleanup() {
		super.cleanup();
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testBasicOpenApiGeneratorIntegration(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "BasicOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testBasicOpenApiGeneratorIntegration(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testBasicOpenApiGeneratorIntegration(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiGeneratorWithoutFlag(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "BasicOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiGeneratorWithoutFlag(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiGeneratorWithoutFlag(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiResourceLifecycle(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "BasicOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiResourceLifecycle(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiResourceLifecycle(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiSpecContentVerification(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "BasicOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiSpecContentVerification(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiSpecContentVerification(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testSwaggerOpenApiGeneratorIntegration(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "BasicOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testSwaggerOpenApiGeneratorIntegration(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testSwaggerOpenApiGeneratorIntegration(ctx);
	}

}
