/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.openapi.tests;

import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;

/**
 * 
 * @author mark
 * @since 05.10.2025
 */
public class SwaggerOpenApiGeneratorIntegrationTest extends BaseOpenApiIntegrationTest {
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testBasicOpenApiGeneratorIntegration(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "SwaggerOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testBasicOpenApiGeneratorIntegration(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testBasicOpenApiGeneratorIntegration(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiGeneratorWithoutFlag(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "SwaggerOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiGeneratorWithoutFlag(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiGeneratorWithoutFlag(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiResourceLifecycle(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "SwaggerOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiResourceLifecycle(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiResourceLifecycle(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testOpenApiSpecContentVerification(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "SwaggerOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testOpenApiSpecContentVerification(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testOpenApiSpecContentVerification(ctx);
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.openapi.tests.BaseOpenApiIntegrationTest#testSwaggerOpenApiGeneratorIntegration(org.osgi.framework.BundleContext)
	 */
	@Override
	@WithFactoryConfiguration(factoryPid = "SwaggerOpenApiGenerator", location = "?", name = "test")
	@Test
	public void testSwaggerOpenApiGeneratorIntegration(@InjectBundleContext BundleContext ctx) throws InterruptedException {
		super.testSwaggerOpenApiGeneratorIntegration(ctx);
	}

}
