/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.openapi.config;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * Configuration interface for OpenAPI Generator.
 * 
 * @author Mark Hoffmann
 * @since 05.10.2025
 */
@ObjectClassDefinition(name = "OpenAPI Generator Configuration")
public @interface OpenApiConfig {
    @AttributeDefinition(name = "Enable file output", description = "Write OpenAPI spec to file")
    boolean enableFileOutput() default false;
    
    @AttributeDefinition(name = "Output file path", description = "Path where to write OpenAPI spec file")
    String outputFilePath() default "./openapi.yaml";
    
    @AttributeDefinition(name = "API Title", description = "Title for the generated OpenAPI spec")
    String apiTitle() default "Eclipse Fennec Auto-Generated API";
    
    @AttributeDefinition(name = "API Version", description = "Version for the generated OpenAPI spec")
    String apiVersion() default "1.0.0";
}